/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei.bottles;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.integration.jei.ReactiveJEIPlugin;
import dev.hyperlynx.reactive.integration.jei.SlotManager;
import dev.hyperlynx.reactive.integration.jei.bottles.PowerBottleRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PowerBottleRecipeCategory
implements IRecipeCategory<PowerBottleRecipe> {
    SlotManager slot_manager = new SlotManager();

    public PowerBottleRecipeCategory() {
        this.slot_manager.addSlot("bottle", 1, 1);
        this.slot_manager.addSlot("power", 1, 21);
    }

    public RecipeType<PowerBottleRecipe> getRecipeType() {
        return RecipeType.create((String)"reactive", (String)"power_bottle", PowerBottleRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"title.reactive.power_bottle_contains");
    }

    @Nullable
    public IDrawable getIcon() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)Registration.QUARTZ_BOTTLE.get()).m_7968_());
    }

    public void draw(PowerBottleRecipe recipe, @Nullable IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics gui, double mouseX, double mouseY) {
        this.background().draw(gui);
        this.slot_manager.drawAllSlotBackgrounds(gui);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PowerBottleRecipe recipe, IFocusGroup focus_group) {
        IRecipeSlotBuilder bottle_slot = this.slot_manager.buildSlot(builder, "bottle", RecipeIngredientRole.INPUT);
        bottle_slot.addIngredients(recipe.bottle);
        IRecipeSlotBuilder power_slot = this.slot_manager.buildSlot(builder, "power", RecipeIngredientRole.INPUT);
        power_slot.addIngredients((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, List.of(recipe.power));
    }

    public IDrawable background() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawable(ReactiveMod.location("textures/gui/bottle_jei.png"), 2, 2, 18, 38);
    }

    public int getWidth() {
        return this.background().getWidth();
    }

    public int getHeight() {
        return this.background().getHeight();
    }
}

