/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jsonthings;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.ObjValue;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.integration.jsonthings.JsonPowerBuilder;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class PowerParser
extends ThingParser<JsonPowerBuilder> {
    public static final String THING_TYPE = "reactive/power";

    public PowerParser(IEventBus bus) {
        super(GSON, THING_TYPE);
        bus.addListener(this::onRegisterEvent);
    }

    private void onRegisterEvent(RegisterEvent event) {
        event.register(Powers.POWERS.getRegistryKey(), helper -> {
            ReactiveMod.LOGGER.info("Registering thingpacks for {}", (Object)THING_TYPE);
            PowerParser.processAndConsumeErrors((String)THING_TYPE, (Iterable)this.getBuilders(), builder -> helper.register(builder.getRegistryName(), (Object)((Power)builder.get())), BaseBuilder::getRegistryName);
            ReactiveMod.LOGGER.info("Done registering thingpacks for {}", (Object)THING_TYPE);
        });
    }

    protected JsonPowerBuilder processThing(ResourceLocation location, JsonObject json, Consumer<JsonPowerBuilder> builder_modification) {
        JsonPowerBuilder builder = new JsonPowerBuilder(this, location);
        JParse.begin((JsonObject)json).ifKey("color", color -> builder.color(PowerParser.parseColor((ObjValue)color.obj()))).ifKey("bottle", bottle -> builder.bottle((RegistryObject<Item>)RegistryObject.create((ResourceLocation)new ResourceLocation(bottle.string().getAsString()), (IForgeRegistry)ForgeRegistries.ITEMS))).ifKey("render_water_block", water -> builder.water((RegistryObject<Block>)RegistryObject.create((ResourceLocation)new ResourceLocation(water.string().getAsString()), (IForgeRegistry)ForgeRegistries.BLOCKS))).ifKey("invisible", invisible -> builder.setInvisible(invisible.bool().getAsBoolean())).ifKey("name_override", custom_name -> builder.setName(Component.m_237113_((String)custom_name.string().getAsString())));
        builder_modification.accept(builder);
        return builder;
    }
}

