/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.PowerBuilder;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class KubePowerBuilder
extends BuilderBase<Power> {
    private final PowerBuilder builder;

    public KubePowerBuilder(ResourceLocation id) {
        super(id);
        this.builder = new PowerBuilder(id);
    }

    public RegistryInfo getRegistryType() {
        return ReactiveKubeJSPlugin.POWER_REGISTRY_INFO;
    }

    public Power createObject() {
        return this.builder.build();
    }

    public KubePowerBuilder color(int color) {
        this.builder.color(color);
        return this;
    }

    public KubePowerBuilder bottle(ResourceLocation bottle_id) {
        this.builder.bottle = () -> this.getItem(bottle_id, false);
        return this;
    }

    public KubePowerBuilder setNormalWater() {
        this.builder.water(() -> Blocks.f_49990_);
        return this;
    }

    public KubePowerBuilder setMagicWater() {
        this.builder.water((Supplier<Block>)Registration.DUMMY_MAGIC_WATER);
        return this;
    }

    public KubePowerBuilder setFastWater() {
        this.builder.water((Supplier<Block>)Registration.DUMMY_FAST_WATER);
        return this;
    }

    public KubePowerBuilder setNoiseWater() {
        this.builder.water((Supplier<Block>)Registration.DUMMY_NOISE_WATER);
        return this;
    }

    public KubePowerBuilder setCustomWater(Block water) {
        this.builder.water(() -> water);
        return this;
    }

    public KubePowerBuilder setInvisible() {
        this.builder.invisible = true;
        return this;
    }

    public KubePowerBuilder setName(MutableComponent name) {
        this.builder.setName(name);
        return this;
    }

    public Item getItem(ResourceLocation id, boolean barrier_if_invalid) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
        if (item == Items.f_41852_) {
            if (barrier_if_invalid) {
                return Items.f_42127_;
            }
            return null;
        }
        return item;
    }
}

