/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.fx.gui.LitmusScreenOpener;
import dev.hyperlynx.reactive.net.litmus.LitmusData;
import dev.hyperlynx.reactive.net.litmus.LitmusScreenMessage;
import dev.hyperlynx.reactive.net.litmus.UnresolvedLitmusData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LitmusPaperItem
extends Item {
    public static final String TAG_MEASUREMENT = "Measurement";
    public static final String TAG_STATUS = "Status";
    public static final String TAG_MULTI_STATUS = "MultiStatus";
    public static final String TAG_UNRESOLVED_STATUS = "UnresolvedStatus";

    public LitmusPaperItem(Item.Properties props) {
        super(props.m_41487_(1));
    }

    private static MutableComponent statusComponent(String status) {
        switch (Reaction.Status.valueOf(status)) {
            case STABLE: {
                return Component.m_237115_((String)"text.reactive.stable").m_130940_(ChatFormatting.GRAY);
            }
            case VOLATILE: {
                return Component.m_237115_((String)"text.reactive.single_power_reaction_missing_condition").m_130940_(ChatFormatting.GRAY);
            }
            case POWER_TOO_WEAK: {
                return Component.m_237115_((String)"text.reactive.power_too_weak").m_130940_(ChatFormatting.GRAY);
            }
            case MISSING_STIMULUS: {
                return Component.m_237115_((String)"text.reactive.multi_power_reaction_missing_condition").m_130940_(ChatFormatting.GRAY);
            }
            case MISSING_CATALYST: {
                return Component.m_237115_((String)"text.reactive.missing_catalyst").m_130940_(ChatFormatting.GRAY);
            }
            case INHIBITED: {
                return Component.m_237115_((String)"text.reactive.inhibited").m_130940_(ChatFormatting.GRAY);
            }
            case REACTING: {
                return Component.m_237115_((String)"text.reactive.reacting");
            }
        }
        return Component.m_237115_((String)"reaction.reactive.unknown").m_130940_(ChatFormatting.RED);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> hover_text, TooltipFlag tooltip_flag) {
        super.m_7373_(stack, level, hover_text, tooltip_flag);
        if (stack.m_41782_()) {
            if (stack.m_41783_().m_128441_(TAG_STATUS) || ((Boolean)ConfigMan.COMMON.litmusScreen.get()).booleanValue()) {
                hover_text.add((Component)Component.m_237115_((String)"text.reactive.litmus_instructions"));
            } else {
                hover_text.add((Component)Component.m_237115_((String)"text.reactive.litmus_instructions_1"));
                hover_text.add((Component)Component.m_237115_((String)"text.reactive.litmus_instructions_2"));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            if (!player.m_21120_(hand).m_41782_()) {
                return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
            }
            if (!((Boolean)ConfigMan.COMMON.litmusScreen.get()).booleanValue()) {
                player.m_213846_((Component)Component.m_237115_((String)"text.reactive.measurement_header").m_130940_(ChatFormatting.GRAY));
                for (Component line : LitmusPaperItem.buildMeasurementText(player.m_21120_(hand), BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)player.m_20097_()), player.m_6047_())) {
                    player.m_213846_(line);
                }
            } else {
                ItemStack stack = player.m_21120_(hand);
                LitmusScreenOpener.open(new LitmusData(LitmusPaperItem.buildPowerText(stack, BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)player.m_20097_()), false), LitmusPaperItem.buildReactionText(stack, true)));
            }
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!(context.m_43725_().m_8055_(context.m_8083_()).m_60734_() instanceof CrucibleBlock)) {
            return InteractionResult.PASS;
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)context.m_43725_().m_7702_(context.m_8083_());
        if (crucible == null) {
            return InteractionResult.PASS;
        }
        LitmusPaperItem.takeMeasurement(context.m_43722_(), crucible);
        return InteractionResult.SUCCESS;
    }

    public static void takeMeasurement(ItemStack paper, CrucibleBlockEntity crucible) {
        ListTag measurements = new ListTag();
        if (crucible.integrity < 85) {
            CompoundTag warning = new CompoundTag();
            warning.m_128359_("value", Component.m_237115_((String)"text.reactive.litmus_integrity_failure").getString());
            measurements.add((Object)warning);
        }
        for (Power p : crucible.getPowerMap().keySet()) {
            int pow = crucible.getPowerLevel(p);
            if (pow == 0) continue;
            String measurement = p.getName().toUpperCase() + " - " + LitmusPaperItem.getPercent(pow);
            CompoundTag mt = new CompoundTag();
            mt.m_128359_("power", p.getResourceLocation().toString());
            mt.m_128359_("value", measurement);
            measurements.add((Object)mt);
        }
        if (!paper.m_41782_()) {
            paper.m_41751_(new CompoundTag());
        }
        assert (paper.m_41783_() != null);
        if (paper.m_41783_().m_128441_(TAG_STATUS)) {
            paper.m_41783_().m_128473_(TAG_STATUS);
        }
        paper.m_41783_().m_128365_(TAG_MEASUREMENT, (Tag)measurements);
        ListTag unresolved_status_list = new ListTag();
        for (ReactionStatusEntry status : crucible.reaction_status) {
            CompoundTag reaction_data = new CompoundTag();
            reaction_data.m_128365_("reaction", (Tag)StringTag.m_129297_((String)status.reaction_alias()));
            reaction_data.m_128365_("status", (Tag)StringTag.m_129297_((String)status.getStatusAsString()));
            unresolved_status_list.add((Object)reaction_data);
        }
        paper.m_41783_().m_128365_(TAG_UNRESOLVED_STATUS, (Tag)unresolved_status_list);
    }

    public void m_6883_(ItemStack stack, Level level, Entity holder, int tick, boolean unknown) {
        super.m_6883_(stack, level, holder, tick, unknown);
        if (holder instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)holder;
            if (stack.m_41782_() && stack.m_41783_().m_128441_(TAG_UNRESOLVED_STATUS)) {
                ListTag multi_status = new ListTag();
                for (Tag tag : stack.m_41783_().m_128437_(TAG_UNRESOLVED_STATUS, 10)) {
                    if (!(tag instanceof CompoundTag)) continue;
                    CompoundTag reaction_data = (CompoundTag)tag;
                    String alias = reaction_data.m_128423_("reaction").m_7916_();
                    String status = reaction_data.m_128423_("status").m_7916_();
                    MutableComponent full_output_line = this.getReactionOrUnknownComponent(alias, player);
                    full_output_line.m_7220_((Component)LitmusPaperItem.statusComponent(status));
                    multi_status.add((Object)StringTag.m_129297_((String)full_output_line.getString()));
                }
                stack.m_41783_().m_128365_(TAG_MULTI_STATUS, (Tag)multi_status);
                stack.m_41783_().m_128473_(TAG_UNRESOLVED_STATUS);
                Registration.LITMUS_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new LitmusScreenMessage(new UnresolvedLitmusData(stack)));
            }
        }
    }

    private MutableComponent getReactionOrUnknownComponent(String reaction_alias, ServerPlayer player) {
        if (reaction_alias.isEmpty()) {
            return Component.m_237119_();
        }
        if (player.m_8960_().m_135996_(Advancement.Builder.m_138353_().m_138403_(ReactiveMod.location("reactions/" + reaction_alias))).m_8193_()) {
            return ReactiveMod.REACTION_MAN.get(reaction_alias).getName().m_130946_(" ");
        }
        return Component.m_237115_((String)"reaction.reactive.unknown").m_130946_(" ");
    }

    @NotNull
    public static String getPercent(int pow) {
        return pow > 16 ? pow / 16 + "%" : Component.m_237115_((String)"text.reactive.trace").getString();
    }

    public static List<Component> buildPowerText(ItemStack stack, int water_color, boolean crouching) {
        ArrayList<Component> text = new ArrayList<Component>();
        if (!stack.m_41782_()) {
            return text;
        }
        assert (stack.m_41783_() != null);
        if (stack.m_41783_().m_128441_(TAG_STATUS) || !crouching) {
            ListTag measurements = stack.m_41783_().m_128437_(TAG_MEASUREMENT, 10);
            for (Tag tag : measurements) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag measurement = (CompoundTag)tag;
                Object m = "";
                TextColor color = TextColor.m_131266_((int)0xFFFFFF);
                if (measurement.m_128441_("power") && ((Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get()).booleanValue()) {
                    color = Power.readPower(measurement, "power").getTextColor();
                }
                m = (String)m + measurement.m_128461_("value");
                text.add((Component)Component.m_237113_((String)m).m_130948_(Style.f_131099_.m_131148_(color)));
            }
            if (measurements.isEmpty()) {
                text.add((Component)Component.m_237115_((String)"text.reactive.measurement_empty").m_130948_((Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get() != false ? Style.f_131099_.m_178520_(water_color) : Style.f_131099_));
            }
        }
        return text;
    }

    public static List<Component> buildReactionText(ItemStack stack, boolean crouching) {
        ArrayList<Component> text = new ArrayList<Component>();
        if (!stack.m_41782_()) {
            return text;
        }
        assert (stack.m_41783_() != null);
        if (stack.m_41783_().m_128441_(TAG_STATUS)) {
            StringTag reaction_status = (StringTag)stack.m_41783_().m_128423_(TAG_STATUS);
            if (reaction_status == null) {
                return text;
            }
            text.add((Component)LitmusPaperItem.statusComponent(reaction_status.m_7916_()));
        } else if (stack.m_41783_().m_128441_(TAG_MULTI_STATUS) && crouching) {
            ListTag status_list = stack.m_41783_().m_128437_(TAG_MULTI_STATUS, 8);
            for (Tag status_tag : status_list) {
                if (!(status_tag instanceof StringTag)) continue;
                text.add((Component)Component.m_237113_((String)status_tag.m_7916_()));
            }
        }
        return text;
    }

    private static List<Component> buildMeasurementText(ItemStack stack, int water_color, boolean crouching) {
        ArrayList<Component> text = new ArrayList<Component>();
        if (!stack.m_41782_()) {
            return text;
        }
        text.addAll(LitmusPaperItem.buildPowerText(stack, water_color, crouching));
        text.addAll(LitmusPaperItem.buildReactionText(stack, crouching));
        return text;
    }
}

