/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.fx.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.StaffItem;
import dev.hyperlynx.reactive.util.BeamHelper;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WarpStaffItem
extends StaffItem {
    public static final String TAG_BOUND_ENTITY_UUID = "BoundEntityUUID";
    public static final String TAG_CUSTOM_MODEL_DATA = "CustomModelData";
    public static final String TAG_TUTORIAL_FINISHED = "TutorialFinished";
    public static final String TAG_BOUND_ENTITY_NAME = "BoundEntityName";

    public WarpStaffItem(Block block, Item.Properties props, Item repair_item) {
        super(block, props, null, false, () -> 1, repair_item);
    }

    @Override
    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int ticks) {
    }

    @Override
    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public int m_8105_(ItemStack stack) {
        return 0;
    }

    public static boolean hasBoundEntity(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(TAG_BOUND_ENTITY_UUID);
    }

    @Nullable
    public Entity getBoundEntity(Level level, ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel server = (ServerLevel)level;
        return server.m_8791_(stack.m_41783_().m_128342_(TAG_BOUND_ENTITY_UUID));
    }

    public static void tryShowTutorial(Player user, ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_(TAG_TUTORIAL_FINISHED)) {
            user.m_5661_((Component)Component.m_237115_((String)"message.reactive.warp_staff_tutorial"), true);
        }
    }

    private void zap(Player user, Vec3 target, ParticleOptions opt) {
        ParticleScribe.drawParticleZigZag(user.m_9236_(), opt, user.m_146892_().f_82479_, user.m_146892_().f_82480_ - 0.4, user.m_146892_().f_82481_, target.f_82479_, target.f_82480_, target.f_82481_, 5, 3, 0.4);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> hover_text, TooltipFlag tooltip_flag) {
        super.m_7373_(stack, level, hover_text, tooltip_flag);
        if (level != null && WarpStaffItem.hasBoundEntity(stack)) {
            hover_text.add((Component)Component.m_237115_((String)"tooltip.reactive.entity_bound").m_130946_(stack.m_41783_().m_128461_(TAG_BOUND_ENTITY_NAME)));
        } else {
            hover_text.add((Component)Component.m_237115_((String)"tooltip.reactive.no_entity_bound"));
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity wielder, int tick, boolean unknown) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (WarpStaffItem.hasBoundEntity(stack)) {
            Entity bound = this.getBoundEntity(level, stack);
            if (bound != null) {
                ParticleScribe.drawExactParticleRing(level, (ParticleOptions)ParticleTypes.f_123789_, bound.m_20182_(), 0.0, 0.5, 4);
                stack.m_41783_().m_128365_(TAG_CUSTOM_MODEL_DATA, (Tag)IntTag.m_128679_((int)1));
            } else {
                stack.m_41783_().m_128473_(TAG_BOUND_ENTITY_UUID);
            }
        } else {
            stack.m_41783_().m_128365_(TAG_CUSTOM_MODEL_DATA, (Tag)IntTag.m_128679_((int)0));
            if (stack.m_41783_().m_128441_(TAG_BOUND_ENTITY_NAME)) {
                stack.m_41783_().m_128473_(TAG_BOUND_ENTITY_NAME);
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player user, InteractionHand hand) {
        Vec3 end;
        ItemStack stack = user.m_21120_(hand);
        if (WarpStaffItem.onLastDurability(stack)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        int range = (Integer)ConfigMan.COMMON.warpStaffRange.get();
        BlockHitResult blockHit = BeamHelper.playerRayTrace(user.m_9236_(), user, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, range);
        Vec3 blockHitPos = blockHit.m_82450_();
        Vec3 start = user.m_146892_();
        EntityHitResult entityHit = ProjectileUtil.m_37287_((Entity)user, (Vec3)start, (Vec3)(end = start.m_82549_(user.m_20154_().m_82490_((double)range))), (AABB)new AABB(start, end), Objects::nonNull, (double)Double.MAX_VALUE);
        Vec3 beam_end = entityHit == null ? blockHitPos : (entityHit.m_82450_().m_82557_(start) < blockHitPos.m_82557_(start) ? entityHit.m_82450_() : blockHitPos);
        if (user instanceof ServerPlayer) {
            if (!WarpStaffItem.hasBoundEntity(stack) && entityHit != null && entityHit.m_82443_() instanceof LivingEntity) {
                if (entityHit.m_82443_() instanceof ItemEntity || entityHit.m_82443_() instanceof ExperienceOrb) {
                    entityHit.m_82443_().m_6021_(user.m_20182_().f_82479_, user.m_20182_().f_82480_, user.m_20182_().f_82481_);
                    stack.m_41622_(1, (LivingEntity)user, unused -> {});
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                if (!((List)ConfigMan.COMMON.doNotTeleport.get()).contains(entityHit.m_82443_().m_20078_())) {
                    Entity entity;
                    if (!((Boolean)ConfigMan.COMMON.warpStaffAffectsPlayers.get()).booleanValue() && entityHit.m_82443_() instanceof Player) {
                        return InteractionResultHolder.m_19100_((Object)stack);
                    }
                    if (!stack.m_41782_()) {
                        stack.m_41751_(new CompoundTag());
                    }
                    if ((entity = entityHit.m_82443_()) instanceof EnderMan) {
                        EnderMan man = (EnderMan)entity;
                        man.m_6469_(user.m_269291_().m_269425_(), 1.0f);
                        man.m_32533_();
                        user.m_36335_().m_41524_(stack.m_41720_(), 100);
                    } else {
                        stack.m_41783_().m_128365_(TAG_BOUND_ENTITY_UUID, (Tag)NbtUtils.m_129226_((UUID)entityHit.m_82443_().m_20148_()));
                        stack.m_41783_().m_128365_(TAG_TUTORIAL_FINISHED, (Tag)IntTag.m_128679_((int)1));
                        stack.m_41783_().m_128365_(TAG_BOUND_ENTITY_NAME, (Tag)StringTag.m_129297_((String)(entityHit.m_82443_().m_8077_() ? entityHit.m_82443_().m_7770_().getString() : entityHit.m_82443_().m_7755_().getString())));
                    }
                    this.zap(user, beam_end, (ParticleOptions)ParticleTypes.f_123808_);
                    level.m_6263_(null, beam_end.f_82479_, beam_end.f_82480_, beam_end.f_82481_, SoundEvents.f_12376_, SoundSource.PLAYERS, 0.6f, 1.0f + user.m_9236_().f_46441_.m_188501_() * 0.2f);
                    level.m_214171_(GameEvent.f_223706_, entityHit.m_82443_().m_146892_(), GameEvent.Context.m_223717_((Entity)entityHit.m_82443_()));
                }
                stack.m_41622_(1, (LivingEntity)user, unused -> {});
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (WarpStaffItem.hasBoundEntity(stack)) {
                Entity bound = this.getBoundEntity(level, stack);
                if (bound != null) {
                    bound.m_6021_(beam_end.f_82479_, beam_end.f_82480_, beam_end.f_82481_);
                    this.zap(user, beam_end, (ParticleOptions)ParticleTypes.f_123789_);
                    level.m_6269_(null, bound, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    level.m_214171_(GameEvent.f_238175_, bound.m_146892_(), GameEvent.Context.m_223717_((Entity)bound));
                }
                stack.m_41783_().m_128473_(TAG_BOUND_ENTITY_UUID);
                stack.m_41622_(1, (LivingEntity)user, unused -> {});
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            WarpStaffItem.tryShowTutorial(user, stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }
}

