/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigMan {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
    }

    public static class Common {
        public ForgeConfigSpec.IntValue crucibleTickDelay;
        public ForgeConfigSpec.IntValue crucibleRange;
        public ForgeConfigSpec.IntValue areaMemoryRange;
        public ForgeConfigSpec.IntValue maxDisplaceCount;
        public ForgeConfigSpec.IntValue displaceConductRange;
        public ForgeConfigSpec.DoubleValue maxMoveBlockBreakTime;
        public ForgeConfigSpec.ConfigValue<List<String>> doNotTeleport;
        public ForgeConfigSpec.BooleanValue acidMeltBlockEntities;
        public ForgeConfigSpec.BooleanValue lightStaffLightsPermanent;
        public ForgeConfigSpec.BooleanValue registerCommand;
        public ForgeConfigSpec.BooleanValue litmusScreen;
        public ForgeConfigSpec.IntValue lightStaffFrequency;
        public ForgeConfigSpec.IntValue blazeStaffFrequency;
        public ForgeConfigSpec.IntValue mindStaffFrequency;
        public ForgeConfigSpec.IntValue soulStaffFrequency;
        public ForgeConfigSpec.IntValue lightStaffRange;
        public ForgeConfigSpec.IntValue blazeStaffRange;
        public ForgeConfigSpec.IntValue mindStaffRange;
        public ForgeConfigSpec.IntValue soulStaffRange;
        public ForgeConfigSpec.IntValue warpStaffRange;
        public ForgeConfigSpec.IntValue vitalStaffRange;
        public ForgeConfigSpec.DoubleValue mindStaffPower;
        public ForgeConfigSpec.DoubleValue soulStaffPower;
        public ForgeConfigSpec.DoubleValue lightStaffPowerVsUndead;
        public ForgeConfigSpec.IntValue blazeStaffExplosionSize;
        public ForgeConfigSpec.IntValue mindStaffMaxHits;
        public ForgeConfigSpec.IntValue mindStaffBaseMissiles;
        public ForgeConfigSpec.IntValue mindStaffEnchantedMissiles;
        public ForgeConfigSpec.IntValue vitalStaffHealthBoost;
        public ForgeConfigSpec.IntValue vitalStaffRegeneration;
        public ForgeConfigSpec.BooleanValue warpStaffAffectsPlayers;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Options:").push("config");
            this.crucibleTickDelay = builder.comment("The crucible performs a stage of its calculations once every X game ticks. Lower numbers are more responsive, but laggier. [Default: 5]").defineInRange("crucibleTickDelay", 5, 1, 900);
            this.crucibleRange = builder.comment("The crucible affect entities with an area of this radius. [Default: 12]").defineInRange("crucibleRange", 12, 2, 64);
            this.areaMemoryRange = builder.comment("The crucible checks an area this many blocks in radius up to a few times a second. Do not set this too high. [Default: 6]").defineInRange("areaMemoryRange", 6, 2, 64);
            this.doNotTeleport = builder.comment("Certain effects might teleport entities if they are not in this blacklist. [Default: \"minecraft:ender_dragon\", \"minecraft:wither\", \"minecraft:warden\"]").define("doNotTeleport", (Object)Lists.newArrayList((Object[])new String[]{"minecraft:ender_dragon", "minecraft:wither", "minecraft:warden"}));
            this.acidMeltBlockEntities = builder.comment("Whether acid should dissolve entity blocks. This would delete the contents of said blocks. [Default: false]").define("acidMeltBlockEntities", false);
            this.maxMoveBlockBreakTime = builder.comment("Blocks with a base break time beyond this cannot be displaced or made to fall. For finer control, use the relevant block tags. [Default: 35.0]").defineInRange("maxMoveBlockBreakTime", 35.0, 0.0, 10000.0);
            this.maxDisplaceCount = builder.comment("The maximum number of blocks that can be displaced at once by a certain effect. [Default: 128]").defineInRange("maxDisplaceCount", 128, 4, 4096);
            this.displaceConductRange = builder.comment("The maximum distance that a block like Copper can convey a displacement pulse [Default: 8]").defineInRange("copperDisplaceConductRange", 8, 1, 4096);
            builder.comment("Staff Balance:").push("staff_balance");
            builder.comment("Range:").push("range");
            this.blazeStaffRange = builder.comment("The range to which the Blazing Staff of Power's fireballs are accurate. [Default: 24]").defineInRange("blazeStaffRange", 24, 4, 1024);
            this.lightStaffRange = builder.comment("The range of the Radiant Staff of Power. [Default: 64]").defineInRange("lightStaffRange", 64, 4, 1024);
            this.mindStaffRange = builder.comment("The range of the Arcane Staff of Power. [Default: 6]").defineInRange("mindStaffRange", 6, 4, 1024);
            this.soulStaffRange = builder.comment("The range of the Spectral Staff of Power. [Default: 16]").defineInRange("soulStaffRange", 16, 4, 1024);
            this.vitalStaffRange = builder.comment("The size of the area of effect for the Living Staff of Power. [Default: 5]").defineInRange("vitalStaffRange", 5, 4, 1024);
            this.warpStaffRange = builder.comment("The range of the Warping Staff of Power. [Default: 12]").defineInRange("warpStaffRange", 12, 4, 1024);
            builder.pop();
            builder.comment("Frequency:").push("frequency");
            this.lightStaffFrequency = builder.comment("The Radiant Staff of Power will activate every this many ticks while right click is held. [Default: 7]").defineInRange("lightStaffFrequency", 7, 1, 60);
            this.blazeStaffFrequency = builder.comment("The Blazing Staff of Power will activate every this many ticks while right click is held. [Default: 10]").defineInRange("blazeStaffFrequency", 10, 1, 60);
            this.soulStaffFrequency = builder.comment("The Spectral Staff of Power will activate every this many ticks while right click is held. [Default: 14]").defineInRange("soulStaffFrequency", 14, 1, 60);
            this.mindStaffFrequency = builder.comment("The Arcane Staff of Power will activate every this many ticks while right click is held. [Default: 10]").defineInRange("mindStaffFrequency", 10, 1, 60);
            builder.pop();
            builder.comment("Effect Power:").push("power");
            this.blazeStaffExplosionSize = builder.comment("Blazing Staves of Power shoot fireballs that cause explosions of this size. If 0, uses a blaze-like not explosive fireball instead. [Default: 0]").defineInRange("blazeStaffExplosionSize", 0, 0, 10);
            this.lightStaffPowerVsUndead = builder.comment("Undead caught in the Radiant Staff of Power's beam will take this much fire damage each activation. [Default: 7.0]").defineInRange("lightStaffPowerVsUndead", 7.0, 1.0, 100.0);
            this.lightStaffLightsPermanent = builder.comment("Whether the Radiant Staff of Power produces permanent light sources. When false, its lights will gradually vanish. [Default: true]").define("lightStaffLightsPermanent", true);
            this.mindStaffPower = builder.comment("Each bolt from the Arcane Staff of Power will do this much magic damage. [Default: 2.0]").defineInRange("mindStaffPower", 2.0, 1.0, 100.0);
            this.mindStaffMaxHits = builder.comment("The maximum number of bolts that the Arcane Staff of Power can hit a single target with each activation. [Default: 2]").defineInRange("mindStaffMaxHits", 2, 1, 40);
            this.mindStaffBaseMissiles = builder.comment("How many missiles the Arcane Staff of Power shoots each activation. [Default: 4]").defineInRange("mindStaffBaseMissiles", 4, 1, 20);
            this.mindStaffEnchantedMissiles = builder.comment("How many TOTAL missiles the Arcane Staff of Power shoots each activation while enchanted with Wide Range. Recommended to be higher than the prior key. [Default: 7]").defineInRange("mindStaffEnchantedMissiles", 7, 2, 40);
            this.soulStaffPower = builder.comment("Living entities within the Spectral Staff of Power's area of effect will take this much magic damage each activation. [Default: 3.0]").defineInRange("soulStaffPower", 4.0, 1.0, 100.0);
            this.vitalStaffHealthBoost = builder.comment("The Vital Staff of Power gives this level of Health Boost to affected entities. [Default: 3]").defineInRange("vitalStaffHealthBoost", 3, 1, 5);
            this.vitalStaffRegeneration = builder.comment("The Vital Staff of Power gives this level of Regeneration to affected entities. [Default: 3]").defineInRange("vitalStaffRegeneration", 3, 1, 5);
            this.warpStaffAffectsPlayers = builder.comment("Whether the Warping Staff of Power can bind to players. If allowed, this means one can teleport players with no warning from across the map once bound. [Default: false]").define("warpStaffAffectsPlayers", false);
            builder.pop();
            builder.pop();
            this.registerCommand = builder.comment("Whether to register the /reactive command on startup. [Default: true]").define("registerCommand", true);
            this.litmusScreen = builder.comment("This enables the GUI for Litmus Paper. Disabling it restores the original chat-based reporting. [Default: true]").define("litmusScreen", true);
            builder.pop();
        }
    }

    public static class Server {
        public ForgeConfigSpec.BooleanValue useWorldSeed;
        public ForgeConfigSpec.LongValue seed;
        public ForgeConfigSpec.DoubleValue pehkuiSmallSize;
        public ForgeConfigSpec.DoubleValue pehkuiLargeSize;
        public ForgeConfigSpec.ConfigValue<List<String>> disabledReactions;
        public ForgeConfigSpec.BooleanValue allowMaterialDeletion;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("World Specific Value Options:").push("wsv");
            this.seed = builder.comment("The seed value used to generate world-specific values. By default, it is set to your world seed on world load. If you change this, alchemy rules might change!").defineInRange("seed", 42L, Long.MIN_VALUE, Long.MAX_VALUE);
            this.useWorldSeed = builder.comment("Whether to reset the seed to your world seed when loading.").define("resetSeed", true);
            builder.pop();
            builder.comment("Mod Integration Options:").push("integration");
            this.pehkuiSmallSize = builder.comment(":Requires Pehkui: The scale that the Reduction reaction sets nearby creatures to. [Default: 0.65]").defineInRange("pehkuiSmallSize", 0.65, 0.05, 0.95);
            this.pehkuiLargeSize = builder.comment(":Requires Pehkui: The scale that the Enlargement reaction sets nearby creatures to. [Default: 1.33]").defineInRange("pehkuiLargeSize", 1.33, 1.05, 10.0);
            builder.pop();
            builder.comment("Other:").push("other");
            this.disabledReactions = builder.comment("A list of reaction aliases to disable. To see the reaction aliases, use /reactive reaction list [Default: []]").define("disabledReactions", (Object)Lists.newArrayList());
            this.allowMaterialDeletion = builder.comment("If set to true, will permit the use of the /reactive material remove and reset commands, which permanently erase materials from the world. THIS CANNOT BE REVERSED without a backup, use only if necessary! [Default: false]").define("allowMaterialDeletion", false);
            builder.pop();
        }
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue showPowerSources;
        public ForgeConfigSpec.BooleanValue doNotChangeWaterTexture;
        public ForgeConfigSpec.BooleanValue colorizeLitmusOutput;
        public ForgeConfigSpec.BooleanValue listPowersAsIngredients;
        public ForgeConfigSpec.BooleanValue irisCompat;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client Side Options:").push("config");
            this.showPowerSources = builder.comment("Whether to show the sources of each Power in JEI. Disable this for a greater challenge.").define("showPowerSources", true);
            this.doNotChangeWaterTexture = builder.comment("Whether to render all Powers using vanilla Water's icon. Use if Rubidium or other rendering mods make the custom water textures break.").define("doNotChangeWaterTexture", false);
            this.colorizeLitmusOutput = builder.comment("Whether to allow Litmus Paper to use multicolored text. Disable if the colored text is hard to read.").define("colorizeLitmusOutput", true);
            this.listPowersAsIngredients = builder.comment("Whether to show Powers as JEI ingredients.").define("listPowersAsIngredients", true);
            this.listPowersAsIngredients = builder.comment("Whether to show Powers as JEI ingredients.").define("listPowersAsIngredients", true);
            this.irisCompat = builder.comment("Whether gateways should change their renderer to attempt to be compatible with Iris/Oculus if it is detected. Disable if rendering of gateways looks bad or you want them to be invisible with shaders on.").define("irisCompat", true);
            builder.pop();
        }
    }
}

