/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.advancements;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import java.util.List;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ReactionCriterion
extends SimpleCriterionTrigger<ReactionTriggerInstance> {
    private static final String REACTION_ALIAS = "reaction_alias";
    ResourceLocation crit_rl;

    public ReactionCriterion(ResourceLocation rl) {
        this.crit_rl = rl;
    }

    protected ReactionTriggerInstance createInstance(JsonObject json, ContextAwarePredicate pred, DeserializationContext context) {
        String alias = json.get(REACTION_ALIAS).getAsString();
        return new ReactionTriggerInstance(pred, alias);
    }

    public ReactionTriggerInstance createInstance(String alias) {
        return new ReactionTriggerInstance(ContextAwarePredicate.f_285567_, alias);
    }

    public static void triggerForNearbyPlayers(ServerLevel l, String alias, BlockPos center, int range) {
        List nearby_players = l.m_45976_(Player.class, AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)center), (double)range, (double)range, (double)range));
        for (Player p : nearby_players) {
            CriteriaTriggers.REACTION_TRIGGER.trigger((ServerPlayer)p, alias);
        }
    }

    public static void triggerPerfectForNearbyPlayers(ServerLevel l, String alias, BlockPos center, int range) {
        List nearby_players = l.m_45976_(Player.class, AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)center), (double)range, (double)range, (double)range));
        for (Player p : nearby_players) {
            CriteriaTriggers.PERFECT_REACTION_TRIGGER.trigger((ServerPlayer)p, alias);
        }
    }

    public ResourceLocation m_7295_() {
        return this.crit_rl;
    }

    public void trigger(ServerPlayer player, String running_reaction) {
        this.m_66234_(player, instance -> instance.matches(running_reaction));
    }

    public class ReactionTriggerInstance
    extends AbstractCriterionTriggerInstance {
        String reaction_alias;

        public ReactionTriggerInstance(ContextAwarePredicate pred, String reaction_alias) {
            super(ReactionCriterion.this.crit_rl, pred);
            this.reaction_alias = reaction_alias;
        }

        @NotNull
        public JsonObject m_7683_(SerializationContext context) {
            Gson gson = new Gson();
            JsonObject object = super.m_7683_(context);
            object.add(ReactionCriterion.REACTION_ALIAS, gson.toJsonTree((Object)this.reaction_alias, String.class));
            return object;
        }

        public boolean matches(String running_reaction) {
            return running_reaction.equals(this.reaction_alias);
        }
    }
}

