/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import java.util.function.Supplier;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class PowerBuilder {
    public ResourceLocation id;
    public transient int color;
    public transient Supplier<Item> bottle;
    public transient Supplier<Block> water;
    public transient boolean invisible = false;
    public transient MutableComponent custom_component = null;

    public PowerBuilder(ResourceLocation id) {
        this.id = id;
        this.color = 0xFFFFFF;
        this.water = () -> Blocks.f_49990_;
    }

    public PowerBuilder color(int color) {
        this.color = color;
        return this;
    }

    public PowerBuilder bottle(Supplier<Item> bottle) {
        this.bottle = bottle;
        return this;
    }

    public PowerBuilder water(Supplier<Block> water) {
        this.water = water;
        return this;
    }

    public PowerBuilder setName(MutableComponent name) {
        this.custom_component = name;
        return this;
    }

    public Power build() {
        if (this.bottle != null && this.bottle.get().m_7968_().m_41619_()) {
            ReactiveMod.LOGGER.error("Power {} has an invalid bottle item!", (Object)this.id);
        }
        if (this.water != null && this.water.get().m_49966_().m_60713_(Blocks.f_50016_)) {
            throw new InvalidPowerBuilderParameterException("Power " + this.id + " has an invalid water block!");
        }
        Power power = new Power(this.id, this.water, this.color, this.bottle);
        power.invisible = this.invisible;
        power.name_override = this.custom_component;
        return power;
    }

    public static class InvalidPowerBuilderParameterException
    extends RuntimeException {
        public InvalidPowerBuilderParameterException(String msg) {
            super(msg);
        }
    }
}

