/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialModel;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.util.Color;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BuiltInMaterials {
    public static void addToMap(Map<ResourceLocation, Material> map) {
        BuiltInMaterials.addMaterial(map, "example_salt", "Example Material", Map.of((MaterialProperty)MaterialProperties.MODEL_NAME.get(), MaterialModel.CIRCLES.m_7912_(), (MaterialProperty)MaterialProperties.COLOR.get(), new Color(8018869)));
        BuiltInMaterials.addMaterial(map, "example_adept_salt", "Example Material", Map.of((MaterialProperty)MaterialProperties.MODEL_NAME.get(), MaterialModel.SQUARES.m_7912_(), (MaterialProperty)MaterialProperties.COLOR.get(), new Color(6354426)));
        BuiltInMaterials.addMaterial(map, "example_creation_salt", "Example Material", Map.of((MaterialProperty)MaterialProperties.MODEL_NAME.get(), MaterialModel.STATIC.m_7912_(), (MaterialProperty)MaterialProperties.COLOR.get(), new Color(1146982)));
        BuiltInMaterials.addMaterial(map, "example_wool", "Example Dyed Wool", Map.of((MaterialProperty)MaterialProperties.MODEL_NAME.get(), MaterialModel.WOOL.m_7912_(), (MaterialProperty)MaterialProperties.COLOR.get(), new Color(16177844)));
        BuiltInMaterialEvent event = new BuiltInMaterialEvent();
        MinecraftForge.EVENT_BUS.post((Event)event);
        map.putAll(event.getExternalMaterials());
    }

    public static Map<ResourceLocation, Material> generate() {
        HashMap<ResourceLocation, Material> mats = new HashMap<ResourceLocation, Material>();
        BuiltInMaterials.addToMap(mats);
        return mats;
    }

    private static void addMaterial(Map<ResourceLocation, Material> map, String id, String name, Map<MaterialProperty<?>, Object> properties) {
        map.put(ReactiveMod.location(id), new Material(properties, name));
    }

    public static class BuiltInMaterialEvent
    extends Event {
        private final Map<ResourceLocation, Material> externally_made_materials = new HashMap<ResourceLocation, Material>();

        public void addMaterial(ResourceLocation id, Material material) {
            this.externally_made_materials.put(id, material);
        }

        private Map<ResourceLocation, Material> getExternalMaterials() {
            return this.externally_made_materials;
        }
    }
}

