/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.FloatFormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.MaterialFormulaMaps;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class FloatMaterialProperty
extends MaterialProperty<Float> {
    @Override
    public Float instance(Map<Power, Integer> formula) {
        ResourceLocation id = MaterialProperties.PROPERTY_SUPPLIER.get().getKey((Object)this);
        assert (id != null);
        List<FormulaOutcome> outcomes = MaterialFormulaMaps.FORMULA_OUTCOME_MAP.get(id);
        if (outcomes == null || outcomes.isEmpty()) {
            ReactiveMod.LOGGER.error("No outcome map has been defined for {}, defaulting to 0.0", (Object)id);
            return Float.valueOf(0.0f);
        }
        float value = 1.0f;
        for (FormulaOutcome outcome : outcomes) {
            if (!(outcome instanceof FloatFormulaOutcome)) {
                ReactiveMod.LOGGER.error("Outcome map for {} has a non-applicable outcome type set, skipping.", (Object)id);
                continue;
            }
            FloatFormulaOutcome float_outcome = (FloatFormulaOutcome)((Object)outcome);
            value *= float_outcome.calculate(formula);
        }
        return Float.valueOf(value);
    }

    @Override
    public void save(CompoundTag tag, Object value) {
        if (value instanceof Float) {
            Float f = (Float)value;
            tag.m_128365_(this.getTagName(), (Tag)FloatTag.m_128566_((float)f.floatValue()));
        }
    }

    @Override
    public Float fromTag(CompoundTag tag) {
        return Float.valueOf(tag.m_128457_(this.getTagName()));
    }
}

