/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.IntegerFormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.MaterialFormulaMaps;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class IntMaterialProperty
extends MaterialProperty<Integer> {
    @Override
    public Integer instance(Map<Power, Integer> formula) {
        FormulaOutcome formulaOutcome;
        ResourceLocation id = MaterialProperties.PROPERTY_SUPPLIER.get().getKey((Object)this);
        assert (id != null);
        List<FormulaOutcome> outcomes = MaterialFormulaMaps.FORMULA_OUTCOME_MAP.get(id);
        if (outcomes == null || outcomes.isEmpty()) {
            ReactiveMod.LOGGER.error("No outcome map has been defined for {}, defaulting to 0", (Object)id);
            return 0;
        }
        if (outcomes.size() > 1) {
            ReactiveMod.LOGGER.error("Integer outcome maps do not support multiple outcomes in the list, ignoring all but the first.");
        }
        if (!((formulaOutcome = outcomes.get(0)) instanceof IntegerFormulaOutcome)) {
            ReactiveMod.LOGGER.error("Outcome map for {} has a non-applicable outcome type set, defaulting to 0", (Object)id);
            return 0;
        }
        IntegerFormulaOutcome outcome = (IntegerFormulaOutcome)((Object)formulaOutcome);
        return outcome.calculate(formula);
    }

    @Override
    public void save(CompoundTag tag, Object value) {
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            tag.m_128365_(this.getTagName(), (Tag)IntTag.m_128679_((int)i));
        }
    }

    @Override
    public Integer fromTag(CompoundTag tag) {
        return tag.m_128451_(this.getTagName());
    }
}

