/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.Formula;
import dev.hyperlynx.reactive.util.Color;
import dev.hyperlynx.reactive.util.NBTSerializer;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Material {
    private final Reference2ObjectMap<MaterialProperty<?>, Object> properties;
    private String custom_name;
    @Nullable
    private final Formula original_formula;
    @Nullable
    private Discoverer discoverer;
    private String notes = "";
    public static final NBTSerializer<Material> SERIALIZER = new NBTSerializer<Material>(){

        public CompoundTag encode(Material data) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("name", data.custom_name);
            if (data.discoverer != null) {
                tag.m_128365_("discoverer", Discoverer.SERIALIZER.encode(data.discoverer));
            }
            tag.m_128359_("notes", data.notes);
            if (data.original_formula != null) {
                tag.m_128365_("formula", Formula.SERIALIZER.encode(data.original_formula));
            }
            for (MaterialProperty property : data.properties.keySet()) {
                property.save(tag, data.properties.get((Object)property));
            }
            return tag;
        }

        @Override
        @Nullable
        public Material decode(Tag input) {
            if (!(input instanceof CompoundTag)) {
                return null;
            }
            CompoundTag compound = (CompoundTag)input;
            Reference2ObjectArrayMap properties = new Reference2ObjectArrayMap();
            for (MaterialProperty property : MaterialProperties.PROPERTY_SUPPLIER.get().getValues()) {
                if (!compound.m_128441_(property.getTagName())) continue;
                properties.put((Object)property, property.fromTag(compound));
            }
            return new Material((Map<MaterialProperty<?>, Object>)properties, compound.m_128461_("name"), compound.m_128441_("formula") ? Formula.SERIALIZER.decode((Tag)compound.m_128469_("formula")) : null, compound.m_128441_("discoverer") ? Discoverer.SERIALIZER.decode((Tag)compound.m_128469_("discoverer")) : null, compound.m_128461_("notes"));
        }
    };
    private static final int POWER_SAME_THRESHOLD = 100;

    public Material(Map<MaterialProperty<?>, Object> properties, String custom_name, @Nullable Formula original_formula, @Nullable Discoverer discoverer, String notes) {
        this.properties = new Reference2ObjectArrayMap(properties);
        this.custom_name = custom_name;
        this.original_formula = original_formula;
        this.discoverer = discoverer;
        this.notes = notes;
    }

    public Material(Map<MaterialProperty<?>, Object> properties, String custom_name, @Nullable Formula original_formula) {
        this.properties = new Reference2ObjectArrayMap(properties);
        this.custom_name = custom_name;
        this.original_formula = original_formula;
    }

    public Material(Map<MaterialProperty<?>, Object> properties, String custom_name) {
        this.properties = new Reference2ObjectArrayMap(properties);
        this.custom_name = custom_name;
        this.original_formula = null;
    }

    public String getNotes() {
        return this.notes;
    }

    public static Material empty() {
        return new Material(Map.of(), "");
    }

    private String customNameRaw() {
        return this.custom_name;
    }

    @Nullable
    public Formula getOriginalFormula() {
        return this.original_formula;
    }

    @Nullable
    private Discoverer discoverer() {
        return this.discoverer;
    }

    public boolean has(MaterialProperty<?> type) {
        return this.properties.containsKey(type);
    }

    public <T> T get(MaterialProperty<T> type) {
        return (T)this.properties.get(type);
    }

    public <T> T getOrDefault(MaterialProperty<T> key, T default_value) {
        if (this.has(key)) {
            return this.get(key);
        }
        return default_value;
    }

    public Map<MaterialProperty<?>, Object> properties() {
        return this.properties;
    }

    public String toString() {
        Tag result = SERIALIZER.encode(this);
        return result.m_7916_();
    }

    public Component getNameComponent() {
        if (this.custom_name.isEmpty()) {
            return Component.m_237115_((String)"block.reactive.undiscovered_material");
        }
        return Component.m_237113_((String)this.custom_name);
    }

    public void setName(String name) {
        this.custom_name = name;
    }

    public void setDiscoverer(Player player) {
        long timestamp = this.discoverer != null ? this.discoverer.discovery_timestamp() : System.currentTimeMillis();
        this.discoverer = new Discoverer(player.m_20148_(), player.m_7755_().getString(), timestamp);
    }

    public boolean wasDiscovered() {
        return this.discoverer != null;
    }

    public Player getDiscoverer(Level level) {
        if (this.discoverer == null) {
            return null;
        }
        return level.m_46003_(this.discoverer.uuid);
    }

    public boolean playerDiscoveredThis(Player player) {
        return this.discoverer != null && this.discoverer.uuid.equals(player.m_20148_());
    }

    protected <T> void set(MaterialProperty<T> property, T value) {
        this.properties.put(property, value);
    }

    public boolean formulaMatches(@NotNull Formula formula) {
        if (this.original_formula == null) {
            return false;
        }
        if (!this.original_formula.base_material().equals(formula.base_material())) {
            return false;
        }
        for (Power power : formula.powers().keySet()) {
            if (this.original_formula.powers().containsKey(power)) continue;
            return false;
        }
        for (Power power : this.original_formula.powers().keySet()) {
            if (!formula.powers().containsKey(power)) {
                return false;
            }
            if (Math.abs(formula.powers().get(power) - this.original_formula.powers().get(power)) <= 100) continue;
            return false;
        }
        return true;
    }

    public void setNotes(String notes) {
        if (notes.isEmpty()) {
            this.notes = "";
            return;
        }
        this.notes = notes;
    }

    public Component getDiscovererName(Level level) {
        if (!this.wasDiscovered()) {
            return Component.m_237119_();
        }
        Player player = this.getDiscoverer(level);
        if (player == null) {
            assert (this.discoverer != null);
            return Component.m_237115_((String)"text.reactive.discovered_by").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130946_(this.discoverer.name);
        }
        this.setDiscoverer(player);
        return Component.m_237115_((String)"text.reactive.discovered_by").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_(player.m_7755_());
    }

    public long getDiscoveryTime() {
        if (this.discoverer == null) {
            return 0L;
        }
        return this.discoverer.discovery_timestamp;
    }

    /*
     * WARNING - void declaration
     */
    public MutableComponent formulaComponent() {
        void var5_7;
        Formula original_formula = this.getOriginalFormula();
        if (original_formula == null) {
            return Component.m_237115_((String)"ui.reactive.no_formula");
        }
        Map<Power, Integer> original_powers = original_formula.powers();
        if (original_powers.isEmpty()) {
            return Component.m_237115_((String)"ui.reactive.no_formula");
        }
        ArrayList<Object> formula_lines = new ArrayList<Object>();
        formula_lines.add(original_formula.base_material().m_7626_(original_formula.base_material().m_7968_()));
        for (Power power : original_powers.keySet().stream().sorted(Comparator.comparing(original_powers::get).reversed()).toList()) {
            formula_lines.add(Component.m_237113_((String)(power.getName() + ": " + Math.round((double)original_powers.get(power).intValue() / 16.0) + "%")).m_130948_(Style.f_131099_.m_178520_(Material.shouldColorizeAgainstBlack(power.getColor()) ? power.getColor().hex : 0xFFFFFF)));
        }
        MutableComponent readout_message = Component.m_237119_();
        boolean bl = false;
        while (var5_7 < formula_lines.size()) {
            readout_message.m_7220_((Component)formula_lines.get((int)var5_7));
            if (var5_7 < formula_lines.size() - 1) {
                readout_message.m_130946_("\n");
            }
            ++var5_7;
        }
        return readout_message;
    }

    private static boolean shouldColorizeAgainstBlack(Color color) {
        int threshold = 90;
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return false;
        }
        return (Boolean)ConfigMan.CLIENT.colorizeLitmusOutput.get() != false && (color.red > threshold || color.green > threshold || color.blue > threshold);
    }

    public record Discoverer(UUID uuid, String name, long discovery_timestamp) {
        public static final NBTSerializer<Discoverer> SERIALIZER = new NBTSerializer<Discoverer>(){

            @Override
            public Tag encode(Discoverer data) {
                CompoundTag tag = new CompoundTag();
                tag.m_128362_("uuid", data.uuid);
                tag.m_128359_("name", data.name);
                tag.m_128356_("timestamp", data.discovery_timestamp);
                return tag;
            }

            @Override
            @Nullable
            public Discoverer decode(Tag tag) {
                if (!(tag instanceof CompoundTag)) {
                    return null;
                }
                CompoundTag input = (CompoundTag)tag;
                try {
                    return new Discoverer(input.m_128342_("uuid"), input.m_128461_("name"), input.m_128454_("timestamp"));
                }
                catch (Exception e) {
                    ReactiveMod.LOGGER.error("Failed to load discoverer object: {}", (Object)e.toString());
                    return null;
                }
            }
        };
    }
}

