/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material.formula;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.util.NBTExtras;
import dev.hyperlynx.reactive.util.NBTSerializer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record Formula(Map<Power, Integer> powers, Item base_material) {
    public static final NBTSerializer<Formula> SERIALIZER = new NBTSerializer<Formula>(){
        private static final NBTSerializer<Power> POWER_SERIALIZER = new NBTSerializer<Power>(){

            public CompoundTag encode(Power data) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("power", data.getResourceLocation().toString());
                return tag;
            }

            @Override
            @Nullable
            public Power decode(Tag input) {
                if (input instanceof CompoundTag) {
                    CompoundTag c = (CompoundTag)input;
                    return Power.readPower(c, "power");
                }
                return null;
            }
        };

        public CompoundTag encode(Formula data) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("powers", (Tag)NBTExtras.encodeMap(POWER_SERIALIZER, NBTExtras.INT, data.powers));
            tag.m_128359_("base_material", data.base_material.m_204114_().m_205785_().m_135782_().toString());
            return tag;
        }

        @Override
        @Nullable
        public Formula decode(Tag input) {
            if (input instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)input;
                Map<Power, Integer> powers = NBTExtras.decodeMap(POWER_SERIALIZER, NBTExtras.INT, compound.m_128437_("powers", 10));
                Item base_material = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)compound.m_128461_("base_material")));
                return new Formula(powers, base_material);
            }
            return null;
        }
    };

    public Formula copy() {
        return new Formula(new HashMap<Power, Integer>(this.powers), this.base_material);
    }
}

