/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material.formula;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.IntegerFormulaOutcome;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class IntegerZeroToMaxFormulaOutcome
extends FormulaOutcome
implements IntegerFormulaOutcome {
    final ResourceLocation power;
    final int min_power;
    final int max_power;
    final int max_value;
    public static final MapCodec<IntegerZeroToMaxFormulaOutcome> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("power").forGetter(IntegerZeroToMaxFormulaOutcome::power), (App)Codec.INT.fieldOf("min_power").forGetter(IntegerZeroToMaxFormulaOutcome::getMinPower), (App)Codec.INT.fieldOf("max_power").forGetter(IntegerZeroToMaxFormulaOutcome::getMaxPower), (App)Codec.INT.fieldOf("max_value").forGetter(IntegerZeroToMaxFormulaOutcome::getMaxValue)).apply((Applicative)instance, IntegerZeroToMaxFormulaOutcome::new));

    public IntegerZeroToMaxFormulaOutcome(ResourceLocation power, int threshold, int max_power, int max_value) {
        this.power = power;
        this.min_power = threshold;
        this.max_power = max_power;
        this.max_value = max_value;
    }

    public int getMinPower() {
        return this.min_power;
    }

    public int getMaxPower() {
        return this.max_power;
    }

    public int getMaxValue() {
        return this.max_value;
    }

    @Override
    public ResourceLocation power() {
        return this.power;
    }

    @Override
    public int calculate(Map<Power, Integer> formula) {
        Power power = (Power)Powers.POWER_SUPPLIER.get().getValue(this.power());
        if (formula.containsKey(power) && formula.get(power) > this.getMinPower()) {
            int provided_power = Math.min(formula.get(power) - this.getMinPower(), this.getMaxPower());
            double power_proportion = (double)provided_power / (double)this.getMaxPower();
            return (int)(power_proportion * (double)this.getMaxValue());
        }
        return 0;
    }
}

