/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.alchemy.rxn.SynthesisReaction;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class AstralSynthesisReaction
extends SynthesisReaction {
    public AstralSynthesisReaction(String alias, Power resultPower, Power ... reagents) {
        super(alias, resultPower, reagents);
        this.reagents.replaceAll((p, v) -> 1);
    }

    @Override
    public void run(Reactor reactor) {
        super.run(reactor);
        reactor.addPower((Power)Powers.ASTRAL_POWER.get(), 1600);
        Objects.requireNonNull(reactor.obtainLevel()).m_5594_(null, reactor.blockPos(), SoundEvents.f_11859_, SoundSource.BLOCKS, 0.5f, 1.2f);
        ParticleScribe.drawParticleSphere(Objects.requireNonNull(reactor.obtainLevel()), (ParticleOptions)Registration.STARDUST_PARTICLE, reactor.blockPos(), 0.5, 1.0, 20);
        Objects.requireNonNull(reactor.obtainLevel()).m_247517_(null, reactor.blockPos(), (SoundEvent)Registration.RUMBLE_SOUND.get(), SoundSource.BLOCKS);
        if (reactor instanceof CrucibleBlockEntity) {
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)reactor;
            crucible.integrity = 12;
        }
    }
}

