/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;

public class CurseAssimilationReaction
extends Reaction {
    int rate = WorldSpecificValues.CURSE_RATE.get();

    public CurseAssimilationReaction(String alias) {
        super(alias, 0);
    }

    @Override
    public boolean isPerfect(Reactor crucible) {
        return true;
    }

    @Override
    public void run(Reactor reactor) {
        super.run(reactor);
        reactor.expendAnyPowerExcept((Power)Powers.ASTRAL_POWER.get(), this.rate);
        reactor.addPower((Power)Powers.CURSE_POWER.get(), this.rate);
        if ((double)Objects.requireNonNull(reactor.obtainLevel()).f_46441_.m_188501_() < 0.2 && reactor.getPowerLevel((Power)Powers.CURSE_POWER.get()) > WorldSpecificValue.get("curse_assim_hurt_threshold", 900, 1100)) {
            AABB aoe = new AABB(reactor.blockPos());
            aoe = aoe.m_82400_(3.0);
            List nearby_ents = reactor.obtainLevel().m_45976_(LivingEntity.class, aoe);
            for (LivingEntity e : nearby_ents) {
                if (!CrystalIronItem.effectNotBlocked(e, 1)) continue;
                e.m_6469_(reactor.obtainLevel().m_269111_().m_269425_(), 1.0f);
            }
        }
    }

    @Override
    public Reaction.Status conditionsMet(Reactor crucible) {
        boolean has_curse;
        boolean bl = has_curse = crucible.getPowerLevel((Power)Powers.CURSE_POWER.get()) > this.rate;
        if (crucible.getTotalPowerLevel() > crucible.getPowerLevel((Power)Powers.CURSE_POWER.get()) + this.rate && has_curse) {
            return Reaction.Status.REACTING;
        }
        return Reaction.Status.STABLE;
    }
}

