/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.List;

public class DecomposeReaction
extends Reaction {
    List<Power> results;
    int rate;

    public DecomposeReaction(String alias, Power reagent, Power ... results) {
        super(alias, 0);
        this.rate = WorldSpecificValue.get(alias + "rate", 10, 20);
        this.reagents.put(reagent, this.rate);
        this.results = List.of(results);
    }

    @Override
    public void run(Reactor crucible) {
        super.run(crucible);
        this.reagents.forEach(crucible::expendPower);
        this.results.forEach(result -> crucible.addPower((Power)result, Math.min(this.rate / this.results.size(), 1)));
    }

    @Override
    public boolean isPerfect(Reactor crucible) {
        for (Power p : crucible.getPowerMap().keySet()) {
            if (this.reagents.containsKey(p) || this.results.contains(p)) continue;
            return false;
        }
        return true;
    }
}

