/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.PowerBearer;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.net.rxn.ReactionStatusMessage;
import dev.hyperlynx.reactive.util.AreaMemory;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

@DontObfuscate
public interface Reactor
extends PowerBearer {
    public List<ReactionStatusEntry> getReactionStatus();

    public void resetReactionStatus();

    default public void react(ServerLevel level) {
        this.setUsedCrystalThisCycle(false);
        this.resetReactionStatus();
        for (Reaction r : ReactiveMod.REACTION_MAN.getReactions()) {
            Reaction.Status reaction_status = r.conditionsMet(this);
            if (reaction_status == Reaction.Status.REACTING) {
                r.run(this);
                this.setDirty();
            }
            if (reaction_status == Reaction.Status.STABLE) continue;
            this.getReactionStatus().add(new ReactionStatusEntry(reaction_status, r.getAlias()));
        }
        BlockPos pos = this.blockPos();
        Registration.REACTION_SYNC_CHANNEL.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)32.0, (ResourceKey)level.m_46472_())), (Object)this.getStatusMessage());
        if (this.getReactionStatus().isEmpty()) {
            this.getReactionStatus().add(ReactionStatusEntry.stable());
        }
        if (!this.hasUsedCrystalThisCycle() && this.getLinkedCrystal() != null) {
            this.unlinkCrystal((Level)level, this.blockPos(), this.blockState());
        }
    }

    default public boolean checkGoldSymbol() {
        return this.getAreaMemory().exists(this.obtainLevel(), (Block)Registration.GOLD_SYMBOL.get());
    }

    public boolean hasUsedCrystalThisCycle();

    public void setUsedCrystalThisCycle(boolean var1);

    public BlockState blockState();

    public BlockPos blockPos();

    public Vec3 getPos();

    public void unlinkCrystal(Level var1, BlockPos var2, BlockState var3);

    public void setDirty();

    public AreaMemory getAreaMemory();

    public Level obtainLevel();

    public int getElectricCharge();

    public EndCrystal getLinkedCrystal();

    public void setLinkedCrystal(EndCrystal var1);

    public Iterable<String> getRenderReactions();

    public void setElectricCharge(int var1);

    default public void addElectricCharge(int i) {
        this.setElectricCharge(this.getElectricCharge() + i);
    }

    public void clearRenderReactions();

    public void addRenderReaction(String var1);

    default public boolean areReactionsPaused() {
        return false;
    }

    public ReactionStatusMessage getStatusMessage();
}

