/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.advancements.FlagCriterion;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;

public class SynthesisReaction
extends Reaction {
    Power resultPower;
    int rate;

    public SynthesisReaction(String alias, Power resultPower, Power ... reagents) {
        super(alias, reagents);
        this.rate = WorldSpecificValue.get(alias + "rate", 40, 100);
        this.resultPower = resultPower;
    }

    @Override
    public void run(Reactor crucible) {
        super.run(crucible);
        for (Power p : this.reagents.keySet()) {
            crucible.expendPower(p, this.rate);
        }
        crucible.addPower(this.resultPower, this.rate);
        if (!Objects.requireNonNull(crucible.obtainLevel()).f_46443_) {
            FlagCriterion.triggerForNearbyPlayers((ServerLevel)crucible.obtainLevel(), CriteriaTriggers.SEE_SYNTHESIS_TRIGGER, crucible.blockPos(), 8);
        }
    }

    @Override
    public boolean isPerfect(Reactor crucible) {
        for (Power p : crucible.getPowerMap().keySet()) {
            if (this.reagents.containsKey(p) || p.equals(this.resultPower)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return super.toString() + " - synthesis reaction";
    }
}

