/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MaterialBlockEntity
extends BlockEntity {
    ResourceLocation material_id;
    public int generic_delay = 0;

    public MaterialBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)Registration.MATERIAL_BE.get(), pos, blockState);
    }

    public Material getMaterial() {
        if (this.material_id == null) {
            return Material.empty();
        }
        return MaterialMan.fetch(this.f_58857_, this.material_id);
    }

    public void setMaterial(Level level, ResourceLocation material_id) {
        if (MaterialMan.occupied(level, material_id)) {
            this.material_id = material_id;
        } else {
            ReactiveMod.LOGGER.error("Material block tried to take an invalid id {}, which is not yet occupied.", (Object)material_id);
        }
    }

    public boolean hasNoValidMaterial() {
        return this.material_id == null;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.material_id = ResourceLocation.m_135820_((String)tag.m_128461_("material_id"));
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.material_id == null) {
            return;
        }
        tag.m_128365_("material_id", (Tag)StringTag.m_129297_((String)this.material_id.toString()));
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public ResourceLocation getMaterialId() {
        return this.material_id;
    }
}

