/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.be.GatewayBlockEntity;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GatewayBlock
extends Block
implements EntityBlock {
    private final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);

    public GatewayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == Registration.GATEWAY_BE.get() ? GatewayBlockEntity::tick : null;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new GatewayBlockEntity(pos, state);
    }

    @Nullable
    public static GlobalPos getDestination(GatewayBlockEntity gateway, ServerLevel level) {
        if (gateway.target != null) {
            ServerLevel target_level = level.m_7654_().m_129880_(gateway.target.m_122640_());
            if (target_level == null) {
                ReactiveMod.LOGGER.error("Invalid destination dimension for gateway!");
                return null;
            }
            return gateway.target;
        }
        ReactiveMod.LOGGER.error("No destination set for gateway!");
        return null;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel slevel = (ServerLevel)level;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof GatewayBlockEntity)) {
            ReactiveMod.LOGGER.error("Invalid gateway block entity at {}!", (Object)pos);
            return;
        }
        GatewayBlockEntity gateway = (GatewayBlockEntity)blockEntity;
        if (!((List)ConfigMan.COMMON.doNotTeleport.get()).contains(entity.m_20078_()) && !gateway.isOnCooldown()) {
            GlobalPos destination = GatewayBlock.getDestination(gateway, slevel);
            if (destination == null) {
                ReactiveMod.LOGGER.error("No valid destination for the gateway at {}!", (Object)pos);
                return;
            }
            ServerLevel target_level = level.m_7654_().m_129880_(destination.m_122640_());
            if (target_level == null) {
                ReactiveMod.LOGGER.error("No valid dimension for the gateway at {}!", (Object)pos);
                return;
            }
            Vec3 target_vector = Vec3.m_82512_((Vec3i)destination.m_122646_());
            entity.m_264318_(target_level, target_vector.m_7096_(), target_vector.m_7098_(), target_vector.m_7094_(), Set.of(), entity.m_146908_(), entity.m_146909_());
            gateway.setCooldown(20);
        }
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPE;
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)Registration.WARP_BOTTLE.get()) && !WarpBottleItem.isRiftBottle(stack)) {
            stack.m_41774_(1);
            ItemStack rift_bottle = ((Item)Registration.WARP_BOTTLE.get()).m_7968_();
            WarpBottleItem.makeRiftBottle(rift_bottle, (ResourceKey<Level>)level.m_46472_(), player.m_20183_());
            player.m_36356_(rift_bottle);
            level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.PLAYERS, 1.0f, 0.5f);
            ParticleScribe.drawExactParticleRing(level, (ParticleOptions)ParticleTypes.f_123760_, player.m_20182_(), 0.0, 0.5, 10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

