/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionEffects;
import dev.hyperlynx.reactive.be.GatewayBlockEntity;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import dev.hyperlynx.reactive.mixin.EndGatewayExitViewerMixin;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class GatewayPlinthBlock
extends Block {
    private final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)7.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0)});
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");

    public GatewayPlinthBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE});
        super.m_7926_(builder);
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.SHAPE;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50446_)) {
                GatewayPlinthBlock.convertEndGateway(slevel, pos.m_7494_());
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && !level.m_8055_(pos.m_7494_()).m_60713_((Block)Registration.GATEWAY_BLOCK.get())) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        }
        super.m_6861_(state, level, pos, pNeighborBlock, pNeighborPos, pMovedByPiston);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50446_)) {
                GatewayPlinthBlock.convertEndGateway(slevel, pos.m_7494_());
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit_result) {
        ItemStack stack = player.m_21120_(hand);
        if (((Power)Powers.WARP_POWER.get()).matchesBottle(stack)) {
            if (WarpBottleItem.isRiftBottle(stack)) {
                assert (stack.m_41783_() != null);
                GlobalPos warp_target = WarpBottleItem.getTeleportPosition(stack.m_41783_());
                if (warp_target == null) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.reactive.activate_plinth_failed"), true);
                    return InteractionResult.PASS;
                }
                GatewayPlinthBlock.setGateway(level, pos.m_7494_(), warp_target, state);
                level.m_247517_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS);
                level.m_5594_(null, pos, SoundEvents.f_11862_, SoundSource.BLOCKS, 0.9f, 0.75f);
                level.m_5594_(null, pos, SoundEvents.f_11700_, SoundSource.BLOCKS, 0.3f, 1.0f);
                player.m_21008_(hand, ((Item)Registration.QUARTZ_BOTTLE.get()).m_7968_());
                return InteractionResult.SUCCESS;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer splayer = (ServerPlayer)player;
                ResourceLocation warp_research = ReactiveMod.location("be_teleported");
                if (splayer.m_8960_().m_135996_(Advancement.Builder.m_138353_().m_138403_(warp_research)).m_8193_()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.reactive.reject_warp_knowledgeable"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.reactive.reject_warp_naive"), true);
                }
            }
        }
        return InteractionResult.PASS;
    }

    private static void setGateway(Level level, BlockPos source, GlobalPos destination, BlockState self_state) {
        level.m_7731_(source.m_7495_(), (BlockState)self_state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        level.m_7731_(source, ((Block)Registration.GATEWAY_BLOCK.get()).m_49966_(), 2);
        BlockEntity be = level.m_7702_(source);
        if (!(be instanceof GatewayBlockEntity)) {
            return;
        }
        GatewayBlockEntity gateway = (GatewayBlockEntity)be;
        gateway.target = destination;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState new_state, boolean moved_by_piston) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && level.m_8055_(pos.m_7494_()).m_60713_((Block)Registration.GATEWAY_BLOCK.get())) {
            level.m_7471_(pos.m_7494_(), false);
            for (BlockPos point : ReactionEffects.getCreationPoints(pos)) {
                ParticleScribe.drawParticleZigZag(level, (ParticleOptions)Registration.STARDUST_PARTICLE, pos.m_7494_(), point, 10, 7, 0.8);
            }
        }
        super.m_6810_(state, level, pos, new_state, moved_by_piston);
    }

    private static void convertEndGateway(ServerLevel level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof TheEndGatewayBlockEntity)) {
            ReactiveMod.LOGGER.error("Tried to convert an inconvertible block at {}.", (Object)pos);
            return;
        }
        TheEndGatewayBlockEntity end_gateway = (TheEndGatewayBlockEntity)be;
        BlockPos target_pos = ((EndGatewayExitViewerMixin)end_gateway).getExitPortal();
        if (target_pos == null) {
            ReactiveMod.LOGGER.error("No valid destination for the end gateway at {}.", (Object)pos);
            return;
        }
        level.m_7731_(pos, ((Block)Registration.GATEWAY_BLOCK.get()).m_49966_(), 2);
        BlockEntity be2 = level.m_7702_(pos);
        if (!(be2 instanceof GatewayBlockEntity)) {
            ReactiveMod.LOGGER.error("Something went wrong while converting the gateway at {}.", (Object)pos);
            return;
        }
        GatewayBlockEntity gateway = (GatewayBlockEntity)be2;
        gateway.target = GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)target_pos);
    }
}

