/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.blocks;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.MaterialModel;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.be.MaterialBlockEntity;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.net.material.MaterialBESyncMessage;
import dev.hyperlynx.reactive.util.Color;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class MaterialBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<MaterialModel> MODEL = EnumProperty.m_61587_((String)"model", MaterialModel.class);
    public static final BooleanProperty RANDOM_TICKING = BooleanProperty.m_61465_((String)"random_ticking");
    public static final IntegerProperty LIGHT_LEVEL = IntegerProperty.m_61631_((String)"light", (int)0, (int)15);

    public MaterialBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60955_().m_60953_(state -> (Integer)state.m_61143_((Property)LIGHT_LEVEL)));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(MODEL, (Comparable)((Object)MaterialModel.SALT))).m_61124_((Property)RANDOM_TICKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MODEL});
        builder.m_61104_(new Property[]{RANDOM_TICKING});
        builder.m_61104_(new Property[]{LIGHT_LEVEL});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new MaterialBlockEntity(pos, state);
    }

    private BlockState setStateByMaterialId(Level level, BlockState state, ResourceLocation material_id) {
        Material material = MaterialMan.fetch(level, material_id);
        String model_name = material.getOrDefault((MaterialProperty)MaterialProperties.MODEL_NAME.get(), "salt");
        int light_level = material.getOrDefault((MaterialProperty)MaterialProperties.LIGHT.get(), 0);
        return (BlockState)((BlockState)state.m_61124_(MODEL, (Comparable)((Object)MaterialModel.fromName(model_name)))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(light_level));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState to_place_state = state;
        if (MaterialItem.hasMaterialId(stack)) {
            ResourceLocation material_id = MaterialItem.getMaterialId(stack);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MaterialBlockEntity) {
                MaterialBlockEntity mbe = (MaterialBlockEntity)blockEntity;
                mbe.setMaterial(level, material_id);
                if (level instanceof ServerLevel) {
                    ServerLevel slevel = (ServerLevel)level;
                    Registration.GENERAL_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> slevel.m_46745_(pos)), (Object)new MaterialBESyncMessage(mbe.getMaterialId(), pos));
                }
            }
            to_place_state = this.setStateByMaterialId(level, to_place_state, material_id);
            to_place_state = this.setRandomTicking(level, to_place_state, material_id);
            level.m_7731_(pos, to_place_state, 2);
        }
    }

    private Material material(BlockGetter getter, BlockPos pos) {
        BlockEntity entity = getter.m_7702_(pos);
        if (!(entity instanceof MaterialBlockEntity)) {
            return Material.empty();
        }
        MaterialBlockEntity material_entity = (MaterialBlockEntity)entity;
        return material_entity.getMaterial();
    }

    private boolean isGelBlock(BlockState state) {
        return ((MaterialModel)((Object)state.m_61143_(MODEL))).equals((Object)MaterialModel.GEL);
    }

    private boolean isIntangible(BlockGetter getter, BlockPos pos, @Nullable Entity collider) {
        if (collider != null && this.material(getter, pos).has((MaterialProperty)MaterialProperties.SEMITANGIBLE.get())) {
            return collider.m_6144_();
        }
        return this.material(getter, pos).has((MaterialProperty)MaterialProperties.INTANGIBLE.get());
    }

    public boolean m_49967_() {
        return true;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Entity collider = null;
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext entity_context = (EntityCollisionContext)context;
            collider = entity_context.m_193113_();
        }
        if (this.isGelBlock(state) || this.isIntangible(getter, pos, collider)) {
            return Shapes.m_83040_();
        }
        return Shapes.m_83144_();
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (this.isIntangible((BlockGetter)level, pos, entity)) {
            return;
        }
        living.m_7601_(state, this.isGelBlock(state) ? new Vec3((double)0.9f, 0.9, (double)0.9f) : new Vec3((double)0.4f, 0.4, (double)0.4f));
        if (this.material((BlockGetter)level, pos).has((MaterialProperty)MaterialProperties.MAGMA_STEP.get())) {
            MaterialBlock.hurtWithMagmaStep(level, entity);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
        MaterialBlockEntity mbe = (MaterialBlockEntity)level.m_7702_(pos);
        if (mbe == null || mbe.hasNoValidMaterial()) {
            return ((Item)Registration.SALT_BLOCK_ITEM.get()).m_7968_();
        }
        MaterialItem.setMaterialId(stack, mbe.getMaterialId());
        return stack;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        BlockEntity entity = (BlockEntity)params.m_287261_(LootContextParams.f_81462_);
        if (entity instanceof MaterialBlockEntity) {
            MaterialBlockEntity mbe = (MaterialBlockEntity)entity;
            if (mbe.hasNoValidMaterial()) {
                return List.of(((Item)Registration.SALT_BLOCK_ITEM.get()).m_7968_());
            }
            ItemStack stack = ((MaterialItem)((Object)Registration.MATERIAL_ITEM.get())).m_7968_();
            MaterialItem.setMaterialId(stack, mbe.getMaterialId());
            return List.of(stack);
        }
        return super.m_49635_(state, params);
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity victim) {
        if (this.material((BlockGetter)level, pos).has((MaterialProperty)MaterialProperties.MAGMA_STEP.get())) {
            MaterialBlock.hurtWithMagmaStep(level, victim);
        }
    }

    private static void hurtWithMagmaStep(Level level, Entity victim) {
        if (!victim.m_20161_() && victim instanceof LivingEntity) {
            victim.m_6469_(level.m_269111_().m_269047_(), 1.0f);
        }
    }

    public boolean isFireSource(BlockState state, LevelReader level, BlockPos pos, Direction direction) {
        return super.isFireSource(state, level, pos, direction) || this.material((BlockGetter)level, pos.m_7495_()).has((MaterialProperty)MaterialProperties.FIRE_SOURCE.get());
    }

    public float m_5880_(BlockState state, Player player, BlockGetter getter, BlockPos pos) {
        float speed;
        BlockEntity blockEntity;
        Material material = this.material(getter, pos);
        Level level = player.m_9236_();
        if (!level.f_46443_ && this.material(getter, pos).has((MaterialProperty)MaterialProperties.SELF_DEFENSE.get()) && (blockEntity = getter.m_7702_(pos)) instanceof MaterialBlockEntity) {
            MaterialBlockEntity mbe = (MaterialBlockEntity)blockEntity;
            if (mbe.generic_delay == 0) {
                Vec3 center = pos.m_252807_();
                ParticleScribe.drawParticle(level, (ParticleOptions)ParticleTypes.f_123792_, center.f_82479_ + (double)level.f_46441_.m_188501_() - 0.5, center.f_82480_, center.f_82481_ + (double)level.f_46441_.m_188501_() - 0.5);
                float damage = ((Float)material.get((MaterialProperty)MaterialProperties.SELF_DEFENSE.get())).floatValue();
                player.m_6469_(level.m_269111_().m_269425_(), damage);
                ParticleScribe.drawParticleZigZag(level, (ParticleOptions)Registration.ACID_BUBBLE_PARTICLE, center.f_82479_, center.f_82480_, center.f_82481_, player.m_20185_(), (double)(player.m_20192_() / 2.0f) + player.m_20186_(), player.m_20189_(), 5, 10, 0.3);
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11909_, SoundSource.BLOCKS, 0.5f, 0.98f + player.m_9236_().f_46441_.m_188501_() * 0.05f);
                mbe.generic_delay = 20;
            } else {
                --mbe.generic_delay;
            }
        }
        if ((speed = material.getOrDefault((MaterialProperty)MaterialProperties.BREAK_STRENGTH.get(), Float.valueOf(1.0f)).floatValue()) == -1.0f) {
            return 0.0f;
        }
        int forge_check = ForgeEventFactory.doPlayerHarvestCheck((Player)player, (BlockState)state, (boolean)true) ? 30 : 100;
        return player.getDigSpeed(state, pos) / (speed *= 0.75f) / (float)forge_check;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.material(level, pos).getOrDefault((MaterialProperty)MaterialProperties.BLAST_RESISTANCE.get(), Float.valueOf(1.0f)).floatValue();
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return this.material((BlockGetter)level, pos).getOrDefault((MaterialProperty)MaterialProperties.ENCHANT_POWER.get(), Float.valueOf(0.0f)).floatValue();
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return super.getFriction(state, level, pos, entity) * this.material((BlockGetter)level, pos).getOrDefault((MaterialProperty)MaterialProperties.FRICTION.get(), Float.valueOf(1.0f)).floatValue();
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.material(level, pos).getOrDefault((MaterialProperty)MaterialProperties.FLAMMABILITY.get(), 0);
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.material(level, pos).getOrDefault((MaterialProperty)MaterialProperties.REDSTONE.get(), 0);
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return MaterialModel.fromName(this.material((BlockGetter)level, pos).getOrDefault((MaterialProperty)MaterialProperties.MODEL_NAME.get(), "salt")).getSoundType();
    }

    public static int getBlockColor(@NotNull BlockAndTintGetter getter, BlockPos pos) {
        BlockEntity entity = getter.m_7702_(pos);
        if (!(entity instanceof MaterialBlockEntity)) {
            return 0;
        }
        MaterialBlockEntity mbe = (MaterialBlockEntity)entity;
        Color color = mbe.getMaterial().getOrDefault((MaterialProperty)MaterialProperties.COLOR.get(), Color.white());
        return color.hex;
    }

    public boolean m_6724_(BlockState state) {
        return (Boolean)state.m_61143_((Property)RANDOM_TICKING);
    }

    private BlockState setRandomTicking(Level level, BlockState state, ResourceLocation material_id) {
        if (MaterialMan.fetch(level, material_id).has((MaterialProperty)MaterialProperties.WARPING.get())) {
            return (BlockState)state.m_61124_((Property)RANDOM_TICKING, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.material((BlockGetter)level, pos).has((MaterialProperty)MaterialProperties.WARPING.get())) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)RANDOM_TICKING, (Comparable)Boolean.valueOf(false)), 2);
            return;
        }
        for (Direction direction : Direction.m_235667_((RandomSource)level.f_46441_)) {
            BlockPos adjacent_pos = pos.m_121955_(new Vec3i(direction.m_122429_(), direction.m_122430_(), direction.m_122431_()));
            BlockState adjacent_state = level.m_8055_(adjacent_pos);
            if (!adjacent_state.m_60795_() && !adjacent_state.m_60713_(Blocks.f_50083_) && !adjacent_state.m_247087_()) continue;
            level.m_7731_(adjacent_pos, state, 2);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof MaterialBlockEntity) {
                MaterialBlockEntity old_mbe = (MaterialBlockEntity)blockEntity;
                blockEntity = level.m_7702_(adjacent_pos);
                if (blockEntity instanceof MaterialBlockEntity) {
                    MaterialBlockEntity new_mbe = (MaterialBlockEntity)blockEntity;
                    new_mbe.setMaterial((Level)level, old_mbe.getMaterialId());
                    Registration.GENERAL_CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(adjacent_pos)), (Object)new MaterialBESyncMessage(old_mbe.getMaterialId(), adjacent_pos));
                }
            }
            level.m_7471_(pos, false);
            level.m_247517_(null, pos, SoundEvents.f_11852_, SoundSource.BLOCKS);
            float f = level.f_46441_.m_188501_() * 0.6f + 0.4f;
            ParticleScribe.drawParticleBox((Level)level, (ParticleOptions)new DustParticleOptions(new Vector3f(f * 0.9f, f * 0.3f, f), 0.5f), new AABB(pos), 8);
            return;
        }
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.m_6861_(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        if (this.material((BlockGetter)level, pos).has((MaterialProperty)MaterialProperties.REDSTONE_MELTING.get())) {
            if (level.m_277173_(pos) > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_(MODEL, (Comparable)((Object)MaterialModel.GEL)), 2);
            } else {
                level.m_7731_(pos, (BlockState)state.m_61124_(MODEL, (Comparable)((Object)MaterialModel.valueOf(((String)this.material((BlockGetter)level, pos).get((MaterialProperty)MaterialProperties.MODEL_NAME.get())).toUpperCase()))), 2);
            }
        }
    }
}

