/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.material.ClientMaterialMan;
import dev.hyperlynx.reactive.alchemy.material.MaterialData;
import dev.hyperlynx.reactive.blocks.MaterialBlock;
import dev.hyperlynx.reactive.client.gui.DeskScreen;
import dev.hyperlynx.reactive.client.models.HoverQuiltModel;
import dev.hyperlynx.reactive.client.particles.AcidBubbleParticle;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.RuneParticle;
import dev.hyperlynx.reactive.client.particles.SmallBlackRuneParticle;
import dev.hyperlynx.reactive.client.particles.SmallRuneParticle;
import dev.hyperlynx.reactive.client.particles.StardustParticle;
import dev.hyperlynx.reactive.client.renderers.CrucibleRenderer;
import dev.hyperlynx.reactive.client.renderers.GatewayRenderer;
import dev.hyperlynx.reactive.client.renderers.HoverQuiltRenderer;
import dev.hyperlynx.reactive.client.renderers.ReactorEntityRenderer;
import dev.hyperlynx.reactive.client.renderers.SymbolRenderer;
import dev.hyperlynx.reactive.client.renderers.rxn.ReactionRenderers;
import dev.hyperlynx.reactive.integration.iris.IrisGatewayRenderer;
import dev.hyperlynx.reactive.integration.ponder.ReactivePonderPlugin;
import dev.hyperlynx.reactive.items.MaterialItem;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientRegistration {
    public static final ReactionRenderers REACTION_RENDERERS = new ReactionRenderers();
    public static boolean IRIS_MODE = false;

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register(ClientRegistration.class);
        if (ModList.get().isLoaded("iris") || ModList.get().isLoaded("oculus")) {
            IRIS_MODE = true;
        }
    }

    @SubscribeEvent
    public static void registerModelLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(HoverQuiltModel.LAYER_LOCATION, HoverQuiltModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent evt) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)Registration.STARDUST_PARTICLE_TYPE.get(), StardustParticle.StardustParticleProvider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)Registration.RUNE_PARTICLE_TYPE.get(), RuneParticle.RuneParticleProvider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)Registration.SMALL_RUNE_PARTICLE_TYPE.get(), SmallRuneParticle.SmallRuneParticleProvider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)Registration.SMALL_BLACK_RUNE_PARTICLE_TYPE.get(), SmallBlackRuneParticle.SmallBlackRuneParticleProvider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)Registration.ACID_BUBBLE_PARTICLE_TYPE.get(), AcidBubbleParticle.AcidBubbleParticleProvider::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)Registration.ENERGY_PARTICLE_TYPE.get(), EnergyParticle.Provider::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers evt) {
        evt.registerBlockEntityRenderer((BlockEntityType)Registration.CRUCIBLE_BE.get(), CrucibleRenderer::new);
        evt.registerBlockEntityRenderer((BlockEntityType)Registration.SYMBOL_BE.get(), SymbolRenderer::new);
        if (IRIS_MODE && ((Boolean)ConfigMan.CLIENT.irisCompat.get()).booleanValue()) {
            evt.registerBlockEntityRenderer((BlockEntityType)Registration.GATEWAY_BE.get(), IrisGatewayRenderer::new);
        } else {
            evt.registerBlockEntityRenderer((BlockEntityType)Registration.GATEWAY_BE.get(), GatewayRenderer::new);
        }
        evt.registerEntityRenderer(Registration.REACTOR.get(), ReactorEntityRenderer::new);
        evt.registerEntityRenderer(Registration.HOVER_QUILT.get(), HoverQuiltRenderer::new);
        evt.registerEntityRenderer(Registration.THROWN_REACTION_FLASK.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent
    public static void onClientSetupEvent(FMLClientSetupEvent evt) {
        if (ModList.get().isLoaded("create")) {
            ReactivePonderPlugin.clientInit();
        }
        ItemProperties.register((Item)((Item)Registration.MATERIAL_ITEM.get()), (ResourceLocation)ReactiveMod.location("material_model_index"), MaterialItem::getModelOverrideValue);
        ClientMaterialMan.clientside_data = new AtomicReference<MaterialData>(MaterialData.empty());
        MenuScreens.m_96206_((MenuType)((MenuType)Registration.DESK_MENU.get()), DeskScreen::new);
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register(MaterialItem::getItemColor, new ItemLike[]{(ItemLike)Registration.MATERIAL_ITEM.get()});
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, getter, pos, index) -> {
            assert (getter != null);
            return MaterialBlock.getBlockColor(getter, pos);
        }, new Block[]{(Block)Registration.MATERIAL_BLOCK.get()});
    }
}

