/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.gui;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.material.ClientMaterialMan;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.client.gui.BetterFittingMultiLineTextWidget;
import dev.hyperlynx.reactive.items.MaterialItem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MaterialListScreen
extends Screen {
    MaterialsList list_panel;
    BetterFittingMultiLineTextWidget formula_box;
    boolean notes_initialized = false;
    MaterialEntry last_selection = null;

    protected MaterialListScreen() {
        super((Component)Component.m_237115_((String)"ui.reactive.material_list"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.list_panel = new MaterialsList(Minecraft.m_91087_(), 165, this.m_264198_().f_263800_() - 40, this.m_264198_().m_274449_() + 20, this.m_264198_().f_263800_() - 40, 32);
        this.list_panel.m_93507_(this.m_264198_().m_264037_(ScreenAxis.HORIZONTAL) - 165);
        this.m_142416_((GuiEventListener)this.list_panel);
        this.formula_box = new BetterFittingMultiLineTextWidget(this.m_264198_().m_264037_(ScreenAxis.HORIZONTAL) + 25, this.m_264198_().m_274449_() + 20, 150, this.m_264198_().f_263800_() - 40, (Component)Component.m_237119_(), this.getMinecraft().f_91062_);
        this.formula_box.f_93624_ = false;
        this.m_142416_((GuiEventListener)this.formula_box);
    }

    public void m_86600_() {
        super.m_86600_();
        MaterialEntry selection = (MaterialEntry)this.list_panel.m_93511_();
        if (selection == null) {
            this.formula_box.f_93624_ = false;
            this.m_169411_((GuiEventListener)this.formula_box);
            this.notes_initialized = false;
        } else if (selection != this.last_selection) {
            if (this.notes_initialized) {
                this.m_169411_((GuiEventListener)this.formula_box);
            }
            MutableComponent formula = selection.material.formulaComponent();
            int max_width = 0;
            int max_height = 0;
            for (String line : formula.getString().lines().toList()) {
                int width = Minecraft.m_91087_().f_91062_.m_92895_(line);
                if (max_width < width) {
                    max_width = width;
                }
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                max_height += 9;
            }
            this.formula_box = new BetterFittingMultiLineTextWidget(this.formula_box.m_252754_(), this.formula_box.m_252907_(), max_width + this.formula_box.getInnerPadding() * 2, max_height + this.formula_box.getInnerPadding() * 2, (Component)selection.material.formulaComponent(), Minecraft.m_91087_().f_91062_);
            this.formula_box.f_93624_ = true;
            this.m_142416_((GuiEventListener)this.formula_box);
            this.notes_initialized = true;
            this.last_selection = selection;
        }
    }

    static class MaterialEntry
    extends ObjectSelectionList.Entry<MaterialEntry>
    implements GuiEventListener {
        final ResourceLocation material_id;
        final Material material;
        boolean focused = false;

        public MaterialEntry(ResourceLocation material_id) {
            this.material_id = material_id;
            this.material = ClientMaterialMan.data().get(material_id);
        }

        public void m_93692_(boolean focused) {
            this.focused = focused;
        }

        public boolean m_93696_() {
            return this.focused;
        }

        public void m_6311_(@NotNull GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            ItemStack dummy_stack = ((MaterialItem)((Object)Registration.MATERIAL_ITEM.get())).m_7968_();
            MaterialItem.setMaterialId(dummy_stack, this.material_id);
            int top_line = top + 4;
            graphics.m_280203_(dummy_stack, left + 4, top_line + 2);
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, ClientMaterialMan.getName(this.material_id), left + 24, top_line, -1);
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, this.material.getDiscovererName((Level)Minecraft.m_91087_().f_91073_), left + 24, top_line + 12, -1);
        }

        @NotNull
        public Component m_142172_() {
            return this.material.getNameComponent();
        }

        public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
            this.m_93692_(true);
            return true;
        }
    }

    private static class MaterialsList
    extends ObjectSelectionList<MaterialEntry> {
        public MaterialsList(Minecraft client, int width, int height, int y, int y_1, int item_height) {
            super(client, width, height, y, y_1, item_height);
            for (ResourceLocation material_id : ClientMaterialMan.getKeysInDiscoveryOrder()) {
                if (!ClientMaterialMan.data().get(material_id).wasDiscovered()) continue;
                this.m_7085_((AbstractSelectionList.Entry)new MaterialEntry(material_id));
            }
            this.m_93496_(false);
        }

        public int m_5759_() {
            return 165;
        }

        protected int m_5756_() {
            return this.getLeft() + this.m_5759_() + 10;
        }
    }
}

