/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.particles;

import dev.hyperlynx.reactive.particles.EnergyParticleOptions;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final Vec3 target;
    private float speed = 0.05f;
    private final boolean reversed;
    private final boolean orbit;

    protected EnergyParticle(ClientLevel level, double x, double y, double z, EnergyParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z);
        this.sprites = sprites;
        this.target = options.getTarget();
        this.m_6569_(options.m_175813_());
        this.f_107227_ = options.m_252837_().x / 255.0f;
        this.f_107228_ = options.m_252837_().y / 255.0f;
        this.f_107229_ = options.m_252837_().z / 255.0f;
        this.f_107219_ = false;
        this.reversed = options.isReversed();
        this.orbit = options.orbit;
        this.m_107257_(this.reversed || this.orbit ? 20 : 200);
        this.m_108339_(sprites);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float p_172146_) {
        return LightTexture.m_109885_((int)15, (int)15);
    }

    public void m_5989_() {
        super.m_5989_();
        this.m_108339_(this.sprites);
        if (!this.reversed && this.getPos().m_82509_((Position)this.target, (double)(this.speed + 0.01f))) {
            this.m_107274_();
        }
    }

    public void m_6257_(double x, double y, double z) {
        Vec3 move_step;
        Vec3 pos = this.getPos();
        if (this.orbit) {
            Vec3 normalized_toward_center = this.target.m_82546_(pos).m_82541_();
            Vec3 normalized_tangent = new Vec3(-normalized_toward_center.f_82481_, 0.0, normalized_toward_center.f_82479_);
            move_step = normalized_tangent.m_82490_((double)this.speed);
        } else {
            move_step = this.target.m_82546_(pos).m_82541_().m_82490_((double)this.speed);
        }
        if (this.reversed) {
            move_step = move_step.m_82548_();
        }
        super.m_6257_(move_step.f_82479_, move_step.f_82480_, move_step.f_82481_);
    }

    public static class Provider
    implements ParticleProvider<EnergyParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(@NotNull EnergyParticleOptions options, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            EnergyParticle particle = new EnergyParticle(level, x, y, z, options, this.sprites);
            particle.speed = options.getSpeed();
            return particle;
        }
    }
}

