/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.client.models.HoverQuiltModel;
import dev.hyperlynx.reactive.entities.HoverQuilt;
import dev.hyperlynx.reactive.net.quilt.HoverQuiltHeightMessage;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class HoverQuiltRenderer
extends EntityRenderer<HoverQuilt>
implements RenderLayerParent<HoverQuilt, HoverQuiltModel> {
    public static final ResourceLocation TEXTURE_LOCATION = ReactiveMod.location("textures/entity/entity_quilt.png");
    private final HoverQuiltModel model;

    public HoverQuiltRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new HoverQuiltModel(context.m_174023_(HoverQuiltModel.LAYER_LOCATION));
    }

    public static void updateHeight(HoverQuiltHeightMessage payload) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        HoverQuilt.handleHeightUpdate(payload, (Level)Minecraft.m_91087_().f_91073_);
    }

    @NotNull
    public HoverQuiltModel getModel() {
        return this.model;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull HoverQuilt entity) {
        return TEXTURE_LOCATION;
    }

    public void render(@NotNull HoverQuilt quilt, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.m_7392_((Entity)quilt, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        this.model.setupAnim(quilt, (float)quilt.animation_timer + partialTick);
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_85837_(0.0, -1.35, 0.0);
        this.model.m_7695_(poseStack, bufferSource.m_6299_(this.model.m_103119_(TEXTURE_LOCATION)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public static void handleHeightPacket(HoverQuiltHeightMessage payload, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            assert (Minecraft.m_91087_().f_91073_ != null);
            HoverQuilt.handleHeightUpdate(payload, (Level)Minecraft.m_91087_().f_91073_);
        });
        context.get().setPacketHandled(true);
    }
}

