/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.cmd.PowerArgumentType;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import dev.hyperlynx.reactive.net.material.MaterialRenameScreenMessage;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="reactive", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ReactiveCommand {
    private static final SimpleCommandExceptionType ERROR_NO_PLAYER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.reactive.no_player"));
    private static final SimpleCommandExceptionType ERROR_NO_CRUCIBLE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.reactive.no_crucible"));
    private static final SimpleCommandExceptionType ERROR_FAKE_POWER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.reactive.fake_power"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command_builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reactive").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"give_warp_bottle").then(Commands.m_82129_((String)"target", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> ReactiveCommand.giveWarpBottle((CommandSourceStack)context.getSource(), (WorldCoordinates)context.getArgument("target", WorldCoordinates.class)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reaction").then(Commands.m_82127_((String)"list").executes(context -> ReactiveCommand.listReactions((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"reload").executes(context -> ReactiveCommand.reloadReactions())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"power").then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"crucible_location", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"power_id", (ArgumentType)PowerArgumentType.power()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1600)).executes(context -> ReactiveCommand.modifyPower((CommandSourceStack)context.getSource(), (WorldCoordinates)context.getArgument("crucible_location", WorldCoordinates.class), (ResourceLocation)context.getArgument("power_id", ResourceLocation.class), (Integer)context.getArgument("amount", Integer.class), false))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"crucible_location", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"power_id", (ArgumentType)PowerArgumentType.power()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1600)).executes(context -> ReactiveCommand.modifyPower((CommandSourceStack)context.getSource(), (WorldCoordinates)context.getArgument("crucible_location", WorldCoordinates.class), (ResourceLocation)context.getArgument("power_id", ResourceLocation.class), (Integer)context.getArgument("amount", Integer.class), true)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"material").then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ReactiveCommand.giveMaterialBlockItem((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"id"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))))).then(Commands.m_82127_((String)"rename").then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> ReactiveCommand.openRenameScreen((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"id")))))).then(Commands.m_82127_((String)"list").executes(context -> ReactiveCommand.printMaterials((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).then(Commands.m_82127_((String)"confirm-delete").executes(context -> ReactiveCommand.removeMaterial((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"id"))))))).then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(context -> ReactiveCommand.printMaterialInfo((CommandContext<CommandSourceStack>)context, ResourceLocationArgument.m_107011_((CommandContext)context, (String)"id")))))).then(Commands.m_82127_((String)"remove-everything").then(Commands.m_82127_((String)"confirm-delete").executes(ReactiveCommand::removeAllMaterials))));
        dispatcher.register(command_builder);
    }

    private static int reloadReactions() {
        ReactiveMod.REACTION_MAN.reset();
        return 1;
    }

    private static int modifyPower(CommandSourceStack source, WorldCoordinates crucible_location, ResourceLocation power_location, Integer amount, boolean remove) throws CommandSyntaxException {
        BlockPos pos = crucible_location.m_119568_(source);
        ServerLevel level = source.m_81372_();
        if (!level.m_46749_(pos)) {
            throw BlockPosArgument.f_118234_.create();
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CrucibleBlockEntity)) {
            throw ERROR_NO_CRUCIBLE.create();
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)blockEntity;
        Power power = (Power)Powers.POWER_SUPPLIER.get().getValue(power_location);
        if (power == null) {
            throw ERROR_FAKE_POWER.create();
        }
        if (remove) {
            crucible.expendPower(power, amount);
        } else {
            crucible.addPower(power, amount);
        }
        crucible.setDirty();
        return 1;
    }

    private static int giveWarpBottle(CommandSourceStack source, WorldCoordinates target) throws CommandSyntaxException {
        ServerPlayer commander = source.m_230896_();
        if (commander == null) {
            throw ERROR_NO_PLAYER.create();
        }
        ItemStack bottle = ((Item)Registration.WARP_BOTTLE.get()).m_7968_();
        WarpBottleItem.makeRiftBottle(bottle, (ResourceKey<Level>)commander.m_9236_().m_46472_(), target.m_119568_(source));
        commander.m_36356_(bottle);
        return 1;
    }

    private static int listReactions(CommandSourceStack source) throws CommandSyntaxException {
        if (!source.m_230897_()) {
            throw ERROR_NO_PLAYER.create();
        }
        List<String> aliases = ReactiveMod.REACTION_MAN.getReactionAliases();
        aliases.stream().sorted().forEach(alias -> {
            Reaction reaction = ReactiveMod.REACTION_MAN.get((String)alias);
            source.m_288197_(() -> Component.m_237113_((String)(alias + " : " + reaction.getName().getString())), true);
        });
        return 1;
    }

    private static int printMaterials(CommandSourceStack source) {
        source.m_288197_(() -> Component.m_237115_((String)"commands.reactive.material_header"), true);
        List<Map.Entry> materials = MaterialMan.getAll((Level)source.m_81372_()).entrySet().stream().sorted(Comparator.comparing(left -> ((ResourceLocation)left.getKey()).toString())).toList();
        for (Map.Entry material_entry : materials) {
            source.m_288197_(() -> Component.m_237113_((String)(((ResourceLocation)material_entry.getKey()).toString() + " - " + ((Material)material_entry.getValue()).getNameComponent().getString())), true);
        }
        return 1;
    }

    private static int removeMaterial(CommandContext<CommandSourceStack> context, ResourceLocation id) {
        if (!((Boolean)ConfigMan.SERVER.allowMaterialDeletion.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.reactive.material_removal_disabled"));
            return 0;
        }
        if (!MaterialMan.occupied((Level)((CommandSourceStack)context.getSource()).m_81372_(), id)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.reactive.material_not_found"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.reactive.material_removed"), true);
        MaterialMan.remove((Level)((CommandSourceStack)context.getSource()).m_81372_(), id);
        return 1;
    }

    private static int removeAllMaterials(CommandContext<CommandSourceStack> context) {
        if (!((Boolean)ConfigMan.SERVER.allowMaterialDeletion.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.reactive.material_removal_disabled"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.reactive.materials_reset"), true);
        MaterialMan.reset(((CommandSourceStack)context.getSource()).m_81372_());
        return 1;
    }

    private static int giveMaterialBlockItem(CommandContext<CommandSourceStack> context, ResourceLocation material_id, int amount, ServerPlayer player) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        if (!MaterialMan.occupied((Level)level, material_id)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.reactive.material_id_invalid"));
            return 0;
        }
        ItemStack stack = ((MaterialItem)((Object)Registration.MATERIAL_ITEM.get())).m_7968_();
        MaterialItem.setMaterialId(stack, material_id);
        stack.m_41764_(amount);
        player.m_36356_(stack);
        return 1;
    }

    private static int printMaterialInfo(CommandContext<CommandSourceStack> context, ResourceLocation material_id) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        if (!MaterialMan.occupied((Level)level, material_id)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.reactive.material_id_invalid"));
            return 0;
        }
        Material material = MaterialMan.fetch((Level)level, material_id);
        if (material == null) {
            ReactiveMod.LOGGER.error("Material {} was unexpectedly null when printing", (Object)material_id);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(material::getNameComponent, true);
        try {
            ((CommandSourceStack)context.getSource()).m_288197_(material::formulaComponent, true);
        }
        catch (Exception e) {
            ReactiveMod.LOGGER.error("Caught an exception while creating formula component for [{}]: {}", (Object)material_id, (Object)e);
        }
        for (MaterialProperty<?> property : material.properties().keySet()) {
            ResourceLocation property_id = MaterialProperties.PROPERTY_SUPPLIER.get().getKey(property);
            if (property_id == null) {
                ReactiveMod.LOGGER.error("Invalid property couldn't be printed");
                continue;
            }
            if (material.get(property) instanceof Unit) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)property_id.m_214296_("material_property")).m_130940_(ChatFormatting.GRAY), true);
                continue;
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)property_id.m_214296_("material_property")).m_130946_(": ").m_130946_(material.get(property).toString()).m_130940_(ChatFormatting.GRAY), true);
        }
        return 1;
    }

    private static int openRenameScreen(CommandContext<CommandSourceStack> context, ResourceLocation material_id) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        if (!MaterialMan.occupied((Level)level, material_id)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.reactive.material_not_found"));
            return 0;
        }
        if (((CommandSourceStack)context.getSource()).m_230896_() == null) {
            return 0;
        }
        Registration.GENERAL_CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((CommandSourceStack)((CommandSourceStack)context.getSource())).m_230896_()), (Object)new MaterialRenameScreenMessage(material_id));
        return 1;
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        if (((Boolean)ConfigMan.COMMON.registerCommand.get()).booleanValue()) {
            ArgumentTypeInfos.registerByClass(PowerArgumentType.class, (ArgumentTypeInfo)((ArgumentTypeInfo)Registration.POWER_ARGUMENT.get()));
            ReactiveCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }
    }
}

