/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.entities;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.entities.ReactorData;
import dev.hyperlynx.reactive.net.rxn.ReactionStatusMessage;
import dev.hyperlynx.reactive.util.AreaMemory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ReactorEntity
extends Entity
implements Reactor {
    public static final int MAX_POWER = 10000;
    private static final EntityDataAccessor<ReactorData> SYNCED_REACTOR_DATA = SynchedEntityData.m_135353_(ReactorEntity.class, (EntityDataSerializer)((EntityDataSerializer)Registration.REACTOR_DATA_SERIALIZER.get()));
    private static final EntityDataAccessor<Boolean> FORCE_GOLD_SYMBOL = SynchedEntityData.m_135353_(ReactorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final String FORCE_GOLD_SYMBOL_KEY = "force_gold_symbol_key";
    private static final EntityDataAccessor<Boolean> USED_CRYSTAL = SynchedEntityData.m_135353_(ReactorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final String USED_CRYSTAL_KEY = "has_used_crystal";
    private static final EntityDataAccessor<Integer> ELECTRIC_CHARGE = SynchedEntityData.m_135353_(ReactorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String ELECTRIC_CHARGE_KEY = "charge";
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(ReactorEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String LIFESPAN_KEY = "lifespan";
    private ReactorData server_reactor_data = new ReactorData(new HashMap<Power, Integer>(), new ArrayList<ReactionStatusEntry>());
    private static final String REACTOR_DATA_KEY = "reactor_data";
    private EndCrystal linked_crystal;
    private static final String LINKED_CRYSTAL_KEY = "crystal";
    private final List<String> render_aliases = new ArrayList<String>();
    private AreaMemory area_memory = null;
    private int sync_timer = 10;
    private int react_timer = 0;

    public ReactorEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.obtainLevel().f_46443_) {
            return;
        }
        if (this.sync_timer <= 0) {
            this.update();
            this.sync_timer = 10;
        } else {
            --this.sync_timer;
        }
        if (this.react_timer <= 0) {
            this.react((ServerLevel)this.obtainLevel());
            this.react_timer = (Integer)ConfigMan.COMMON.crucibleTickDelay.get() * 5;
        } else {
            --this.react_timer;
        }
        if ((Integer)this.m_20088_().m_135370_(LIFESPAN) <= 0) {
            this.m_6074_();
        }
        this.m_20088_().m_135381_(LIFESPAN, (Object)((Integer)this.m_20088_().m_135370_(LIFESPAN) - 1));
        this.tryMergeWithNeighbor();
    }

    private void tryMergeWithNeighbor() {
        List nearby_others = this.obtainLevel().m_45976_(ReactorEntity.class, this.m_20191_().m_82400_(4.0));
        nearby_others.remove(this);
        for (ReactorEntity neighbor : nearby_others) {
            Vec3 neighbor_pos = neighbor.getPos();
            Vec3 displacement = neighbor_pos.m_82546_(this.getPos());
            Vec3 step = displacement.m_82541_().m_82542_(0.015, 0.015, 0.015);
            this.m_6478_(MoverType.SELF, step);
        }
        List touching_others = this.obtainLevel().m_45976_(ReactorEntity.class, this.m_20191_());
        touching_others.remove(this);
        for (ReactorEntity touching : touching_others) {
            for (Power power : touching.getPowerMap().keySet()) {
                this.addPower(power, touching.getPowerLevel(power));
            }
            this.setLifespan(Math.max(touching.getLifespan(), this.getLifespan()));
            this.setElectricCharge(touching.getElectricCharge() + this.getElectricCharge());
            touching.m_6074_();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SYNCED_REACTOR_DATA, (Object)new ReactorData(new HashMap<Power, Integer>(), new ArrayList<ReactionStatusEntry>()));
        this.f_19804_.m_135372_(FORCE_GOLD_SYMBOL, (Object)false);
        this.f_19804_.m_135372_(USED_CRYSTAL, (Object)false);
        this.f_19804_.m_135372_(ELECTRIC_CHARGE, (Object)0);
        this.f_19804_.m_135372_(LIFESPAN, (Object)6000);
    }

    public ReactorData reactorData() {
        if (this.obtainLevel().f_46443_) {
            return (ReactorData)this.m_20088_().m_135370_(SYNCED_REACTOR_DATA);
        }
        return this.server_reactor_data;
    }

    private void update() {
        if (this.obtainLevel().f_46443_) {
            throw new UnsupportedOperationException("Can't modify the state of the reaction data on the client!");
        }
        this.m_20088_().m_276349_(SYNCED_REACTOR_DATA, (Object)this.server_reactor_data.copy(), true);
    }

    private void update(ReactorData changed) {
        this.server_reactor_data = changed;
        this.update();
    }

    public void setLifespan(int lifespan) {
        this.m_20088_().m_135381_(LIFESPAN, (Object)lifespan);
    }

    public int getLifespan() {
        return (Integer)this.m_20088_().m_135370_(LIFESPAN);
    }

    protected void m_7378_(CompoundTag compound) {
        Level level;
        SynchedEntityData data = this.m_20088_();
        if (compound.m_128441_(REACTOR_DATA_KEY)) {
            this.update(ReactorData.fromTag(compound.m_128469_(REACTOR_DATA_KEY)));
        }
        if (compound.m_128441_(FORCE_GOLD_SYMBOL_KEY)) {
            data.m_135381_(FORCE_GOLD_SYMBOL, (Object)compound.m_128471_(FORCE_GOLD_SYMBOL_KEY));
        }
        if (compound.m_128441_(USED_CRYSTAL_KEY)) {
            data.m_135381_(USED_CRYSTAL, (Object)compound.m_128471_(USED_CRYSTAL_KEY));
        }
        if (compound.m_128441_(ELECTRIC_CHARGE_KEY)) {
            data.m_135381_(ELECTRIC_CHARGE, (Object)compound.m_128451_(ELECTRIC_CHARGE_KEY));
        }
        if (compound.m_128441_(LIFESPAN_KEY)) {
            data.m_135381_(LIFESPAN, (Object)compound.m_128451_(LIFESPAN_KEY));
        }
        if ((level = this.obtainLevel()) instanceof ServerLevel) {
            UUID uuid;
            Entity entity;
            ServerLevel server = (ServerLevel)level;
            if (compound.m_128441_(LINKED_CRYSTAL_KEY) && (entity = server.m_8791_(uuid = compound.m_128342_(LINKED_CRYSTAL_KEY))) instanceof EndCrystal) {
                EndCrystal crystal;
                this.linked_crystal = crystal = (EndCrystal)entity;
            }
        }
    }

    protected void m_7380_(CompoundTag compound) {
        SynchedEntityData data = this.m_20088_();
        compound.m_128365_(REACTOR_DATA_KEY, (Tag)this.reactorData().toTag());
        compound.m_128365_(FORCE_GOLD_SYMBOL_KEY, (Tag)ByteTag.m_128273_((boolean)((Boolean)data.m_135370_(FORCE_GOLD_SYMBOL))));
        compound.m_128365_(USED_CRYSTAL_KEY, (Tag)ByteTag.m_128273_((boolean)((Boolean)data.m_135370_(USED_CRYSTAL))));
        compound.m_128365_(ELECTRIC_CHARGE_KEY, (Tag)IntTag.m_128679_((int)((Integer)data.m_135370_(ELECTRIC_CHARGE))));
        compound.m_128365_(LIFESPAN_KEY, (Tag)IntTag.m_128679_((int)((Integer)data.m_135370_(LIFESPAN))));
        if (this.linked_crystal != null) {
            compound.m_128365_(LINKED_CRYSTAL_KEY, (Tag)NbtUtils.m_129226_((UUID)this.linked_crystal.m_20148_()));
        }
    }

    @Override
    public boolean checkGoldSymbol() {
        return (Boolean)this.m_20088_().m_135370_(FORCE_GOLD_SYMBOL) != false || Reactor.super.checkGoldSymbol();
    }

    @Override
    public List<ReactionStatusEntry> getReactionStatus() {
        return this.reactorData().statuses();
    }

    @Override
    public void resetReactionStatus() {
        ReactorData data = this.reactorData();
        data.statuses().clear();
        this.update(data);
    }

    @Override
    public boolean hasUsedCrystalThisCycle() {
        return (Boolean)this.m_20088_().m_135370_(USED_CRYSTAL);
    }

    @Override
    public void setUsedCrystalThisCycle(boolean used) {
        this.m_20088_().m_135381_(USED_CRYSTAL, (Object)used);
    }

    @Override
    public BlockState blockState() {
        return this.obtainLevel().m_8055_(this.blockPos());
    }

    @Override
    public BlockPos blockPos() {
        return this.m_20183_();
    }

    @Override
    public Vec3 getPos() {
        return this.m_20182_();
    }

    @Override
    public void setDirty() {
    }

    @Override
    public int maxPower() {
        return 10000;
    }

    @Override
    @NotNull
    public Map<Power, Integer> getPowerMap() {
        return this.reactorData().powers();
    }

    @Override
    public AreaMemory getAreaMemory() {
        if (this.area_memory == null) {
            this.area_memory = new AreaMemory(this.blockPos());
        }
        return this.area_memory;
    }

    @Override
    public Level obtainLevel() {
        return this.m_9236_();
    }

    @Override
    public int getElectricCharge() {
        return (Integer)this.m_20088_().m_135370_(ELECTRIC_CHARGE);
    }

    @Override
    public void setElectricCharge(int i) {
        this.m_20088_().m_135381_(ELECTRIC_CHARGE, (Object)i);
    }

    @Override
    public void clearRenderReactions() {
        this.render_aliases.clear();
    }

    @Override
    public void addRenderReaction(String s) {
        this.render_aliases.add(s);
    }

    @Override
    public ReactionStatusMessage getStatusMessage() {
        return new ReactionStatusMessage(this.m_19879_(), this.getReactionStatus());
    }

    @Override
    public Iterable<String> getRenderReactions() {
        return this.render_aliases;
    }

    @Override
    public EndCrystal getLinkedCrystal() {
        return this.linked_crystal;
    }

    @Override
    public void setLinkedCrystal(EndCrystal end_crystal) {
        this.linked_crystal = end_crystal;
    }

    @Override
    public void unlinkCrystal(Level level, BlockPos pos, BlockState state) {
        this.linked_crystal.m_31052_(null);
        this.linked_crystal = null;
    }

    public void setPowers(@NotNull Map<Power, Integer> power_map_to_copy) {
        this.server_reactor_data.powers().clear();
        for (Power power : power_map_to_copy.keySet()) {
            this.server_reactor_data.powers().put(power, power_map_to_copy.get(power));
        }
    }
}

