/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.integration.jei.ReactiveJEIPlugin;
import dev.hyperlynx.reactive.integration.jei.SlotManager;
import dev.hyperlynx.reactive.recipes.DissolveRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class DissolveRecipeCategory
implements IRecipeCategory<DissolveRecipe> {
    SlotManager slot_manager = new SlotManager();

    public DissolveRecipeCategory() {
        this.slot_manager.addSlot("reactant", 1, 1);
        this.slot_manager.addSlot("product", 55, 1);
        this.slot_manager.addSlot("power_result", 55, 22);
    }

    @Nullable
    public ResourceLocation getRegistryName(DissolveRecipe recipe) {
        return recipe.m_6423_();
    }

    public RecipeType<DissolveRecipe> getRecipeType() {
        return RecipeType.create((String)"reactive", (String)"dissolve", DissolveRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"title.reactive.dissolve");
    }

    public IDrawable getBackground() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawable(ReactiveMod.location("textures/gui/tf_jei.png"), 2, 2, 72, 39);
    }

    public IDrawable getIcon() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DissolveRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder input_slot = this.slot_manager.buildSlot(builder, "reactant", RecipeIngredientRole.INPUT);
        IRecipeSlotBuilder output_slot = this.slot_manager.buildSlot(builder, "product", RecipeIngredientRole.OUTPUT);
        input_slot.addItemStacks(List.of(recipe.getReactant().m_43908_()));
        output_slot.addItemStack(recipe.getResultItem());
        if (((Boolean)ConfigMan.CLIENT.showPowerSources.get()).booleanValue()) {
            IRecipeSlotBuilder power_slot = this.slot_manager.buildSlot(builder, "power_result", RecipeIngredientRole.OUTPUT);
            for (ItemStack input : recipe.getReactant().m_43908_()) {
                power_slot.addIngredients((IIngredientType)ReactiveJEIPlugin.POWER_TYPE, Power.getSourcePower(input));
            }
        }
    }

    public void draw(DissolveRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        if (recipe.needs_electricity) {
            this.drawElectricLabel(gui);
        }
        this.slot_manager.drawSlotBackgrounds(gui, List.of("reactant", "product"));
        if (((Boolean)ConfigMan.CLIENT.showPowerSources.get()).booleanValue()) {
            this.slot_manager.drawSlotBackground(gui, "power_result");
        }
    }

    private void drawElectricLabel(GuiGraphics gui) {
        Minecraft minecraft = Minecraft.m_91087_();
        int width = minecraft.f_91062_.m_92895_("Charge");
        int center = this.getBackground().getWidth() / 2;
        int x = center - width / 2;
        int y = 11;
        gui.m_280488_(minecraft.f_91062_, "Charge", x, y, 895144);
    }
}

