/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.util.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class PowerIngredientRenderer
implements IIngredientRenderer<Power> {
    public void render(GuiGraphics gui, Power ingredient) {
        TextureAtlasSprite sprite = PowerIngredientRenderer.getSprite(ingredient);
        Color color = ingredient.getColor();
        if (ingredient == Powers.ASTRAL_POWER.get()) {
            gui.m_285944_(RenderType.m_173242_(), 0, 0, 16, 16, 0);
        } else if (!ingredient.invisible) {
            gui.m_280509_(0, 0, 16, 16, 0xEE000000 | color.hex);
        }
        gui.m_280565_(0, 0, 0, 16, 16, sprite, (float)color.red / 255.0f, (float)color.green / 255.0f, (float)color.blue / 255.0f, ingredient.invisible ? 0.2f : 1.0f);
    }

    @NotNull
    public List<Component> getTooltip(Power ingredient, TooltipFlag tooltipFlag) {
        ArrayList<Component> ret = new ArrayList<Component>();
        ret.add((Component)Component.m_237113_((String)(ingredient.getName() + " Power")));
        if (tooltipFlag.m_7050_()) {
            ret.add((Component)Component.m_237113_((String)("reactive:" + ingredient.getId())).m_130940_(ChatFormatting.GRAY));
        }
        return ret;
    }

    private static TextureAtlasSprite getSprite(Power power) {
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        return dispatcher.m_110910_(power.getRenderBlock().m_49966_()).getParticleIcon(ModelData.EMPTY);
    }
}

