/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.jei;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.AlchemyTags;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.integration.jei.DissolveRecipeCategory;
import dev.hyperlynx.reactive.integration.jei.PowerIngredientHandler;
import dev.hyperlynx.reactive.integration.jei.PowerIngredientRenderer;
import dev.hyperlynx.reactive.integration.jei.PowerIngredientType;
import dev.hyperlynx.reactive.integration.jei.TransmuteRecipeCategory;
import dev.hyperlynx.reactive.integration.jei.bottles.PowerBottleRecipe;
import dev.hyperlynx.reactive.integration.jei.bottles.PowerBottleRecipeCategory;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.items.ReactionFlaskItem;
import dev.hyperlynx.reactive.items.StaffItem;
import dev.hyperlynx.reactive.recipes.DissolveRecipe;
import dev.hyperlynx.reactive.recipes.TransmuteRecipe;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ReactiveJEIPlugin
implements IModPlugin {
    public static IJeiHelpers HELPERS;
    public static DissolveRecipeCategory DISSOLVE_CATEGORY;
    public static TransmuteRecipeCategory TRANSMUTE_CATEGORY;
    public static PowerBottleRecipeCategory POWER_BOTTLE_CATEGORY;
    public static PowerIngredientType POWER_TYPE;
    public static PowerIngredientHandler POWER_HANDLER;
    public static PowerIngredientRenderer POWER_RENDERER;
    public static IJeiRuntime RUNTIME;

    @NotNull
    public ResourceLocation getPluginUid() {
        return ReactiveMod.location("jei_plugin");
    }

    private void setHelpers(IJeiHelpers helpers) {
        if (HELPERS == null) {
            HELPERS = helpers;
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.setHelpers(registration.getJeiHelpers());
        registration.addRecipeCategories(new IRecipeCategory[]{DISSOLVE_CATEGORY});
        registration.addRecipeCategories(new IRecipeCategory[]{TRANSMUTE_CATEGORY});
        registration.addRecipeCategories(new IRecipeCategory[]{POWER_BOTTLE_CATEGORY});
    }

    public void registerIngredients(IModIngredientRegistration registration) {
        registration.register((IIngredientType)POWER_TYPE, Powers.POWER_SUPPLIER.get().getValues(), (IIngredientHelper)POWER_HANDLER, (IIngredientRenderer)POWER_RENDERER);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.setHelpers(registration.getJeiHelpers());
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        registration.addRecipes(DISSOLVE_CATEGORY.getRecipeType(), level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)Registration.DISSOLVE_RECIPE_TYPE.get()));
        registration.addRecipes(TRANSMUTE_CATEGORY.getRecipeType(), level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)Registration.TRANS_RECIPE_TYPE.get()));
        this.addDescriptions(registration);
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_BLAZE_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_LIFE_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_LIGHT_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_MIND_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_WARP_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addStaffRepairRecipe((StaffItem)((Object)Registration.STAFF_OF_SOUL_ITEM.get()), registration, registration.getVanillaRecipeFactory());
        this.addDisplacerRepairRecipe(registration, registration.getVanillaRecipeFactory());
        if (!((Boolean)ConfigMan.CLIENT.listPowersAsIngredients.get()).booleanValue()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)POWER_TYPE, Powers.POWER_SUPPLIER.get().getValues());
        }
        this.addPowerBottleRecipes(registration);
        if (((Boolean)ConfigMan.CLIENT.showPowerSources.get()).booleanValue()) {
            this.addPowerSourceRecipes(registration);
        }
    }

    private void addPowerBottleRecipes(IRecipeRegistration registration) {
        registration.addRecipes(POWER_BOTTLE_CATEGORY.getRecipeType(), Powers.POWER_SUPPLIER.get().getValues().stream().map(power -> power.hasBottle() ? new PowerBottleRecipe(ReactiveMod.location("bottle_of_" + power.getId()), "power_bottles", (Power)power) : null).filter(recipe -> recipe != null).toList());
    }

    private void addPowerSourceRecipes(IRecipeRegistration registration) {
        HashSet<Item> excluded = new HashSet<Item>();
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        List purify_recipes = level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)Registration.DISSOLVE_RECIPE_TYPE.get());
        for (DissolveRecipe r : purify_recipes) {
            for (ItemStack stack : r.getReactant().m_43908_()) {
                excluded.add(stack.m_41720_());
            }
        }
        for (ItemStack i : registration.getIngredientManager().getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            if (Power.getSourcePower(i).isEmpty() || excluded.contains(i.m_41720_())) continue;
            registration.addRecipes(DISSOLVE_CATEGORY.getRecipeType(), List.of(new DissolveRecipe(null, "power_source", Ingredient.m_43927_((ItemStack[])new ItemStack[]{i}), ItemStack.f_41583_, false)));
        }
    }

    private void addDescriptions(IRecipeRegistration registration) {
        registration.addItemStackInfo(((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.crucible")});
        registration.addItemStackInfo(((Item)Registration.SALT.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)Registration.GOLD_FOAM_ITEM.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)Registration.MOTION_SALT.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)Registration.SECRET_SCALE.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)Registration.PHANTOM_RESIDUE.get()).m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.reaction_input")});
        this.addGenericDescriptions(registration, (Item)Registration.STAFF_OF_WARP_ITEM.get(), (Item)Registration.STAFF_OF_MIND_ITEM.get(), (Item)Registration.STAFF_OF_BLAZE_ITEM.get(), (Item)Registration.STAFF_OF_LIFE_ITEM.get(), (Item)Registration.STAFF_OF_LIGHT_ITEM.get(), (Item)Registration.STAFF_OF_SOUL_ITEM.get(), (Item)Registration.SOLID_PORTAL_ITEM.get(), (Item)Registration.LIGHT_BOTTLE.get(), (Item)Registration.MIND_BOTTLE.get(), (Item)Registration.BODY_BOTTLE.get(), (Item)Registration.WARP_BOTTLE.get(), (Item)Registration.BLAZE_BOTTLE.get(), (Item)Registration.ACID_BOTTLE.get(), (Item)Registration.VERDANT_BOTTLE.get(), (Item)Registration.SOUL_BOTTLE.get(), (Item)Registration.VITAL_BOTTLE.get(), (Item)Registration.MNEMONIC_BULB_ITEM.get());
        this.addPowerDescriptions(registration);
        this.addMaterialRecipes(registration);
        this.addReactionFlaskRecipes(registration);
    }

    private void addGenericDescriptions(IRecipeRegistration registration, Item ... items) {
        for (Item item : items) {
            registration.addItemStackInfo(item.m_7968_(), new Component[]{Component.m_237115_((String)"jei.reactive.generic")});
        }
    }

    private void addPowerDescriptions(IRecipeRegistration registration) {
        for (Power power : Powers.POWER_SUPPLIER.get().getValues()) {
            registration.addIngredientInfo((Object)power, (IIngredientType)POWER_TYPE, new Component[]{Component.m_237115_((String)"jei.reactive.power")});
        }
    }

    private void addStaffRepairRecipe(StaffItem staff, IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        ItemStack full_durability = new ItemStack((ItemLike)staff);
        ItemStack three_quarters_durability = new ItemStack((ItemLike)staff);
        three_quarters_durability.m_41721_(full_durability.m_41776_() / 4);
        ItemStack half_durability = new ItemStack((ItemLike)staff);
        half_durability.m_41721_(full_durability.m_41776_() / 2);
        IJeiAnvilRecipe sacrifice_repair_recipe = factory.createAnvilRecipe(half_durability, List.of(half_durability), List.of(full_durability));
        IJeiAnvilRecipe bottle_repair_recipe = factory.createAnvilRecipe(three_quarters_durability, List.of(new ItemStack((ItemLike)staff.repair_item)), List.of(full_durability));
        registration.addRecipes(RecipeTypes.ANVIL, List.of(sacrifice_repair_recipe, bottle_repair_recipe));
    }

    private void addDisplacerRepairRecipe(IRecipeRegistration registration, IVanillaRecipeFactory factory) {
        Item displacer = (Item)Registration.DISPLACER.get();
        ItemStack full_durability = new ItemStack((ItemLike)displacer);
        ItemStack three_quarters_durability = new ItemStack((ItemLike)displacer);
        three_quarters_durability.m_41721_(full_durability.m_41776_() / 4);
        ItemStack half_durability = new ItemStack((ItemLike)displacer);
        half_durability.m_41721_(full_durability.m_41776_() / 2);
        IJeiAnvilRecipe sacrifice_repair_recipe = factory.createAnvilRecipe(half_durability, List.of(half_durability), List.of(full_durability));
        IJeiAnvilRecipe bottle_repair_recipe = factory.createAnvilRecipe(three_quarters_durability, List.of(((Item)Registration.MOTION_SALT.get()).m_7968_()), List.of(full_durability));
        registration.addRecipes(RecipeTypes.ANVIL, List.of(sacrifice_repair_recipe, bottle_repair_recipe));
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        RUNTIME = jeiRuntime;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_(), new RecipeType[]{DISSOLVE_CATEGORY.getRecipeType()});
        registration.addRecipeCatalyst(((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_(), new RecipeType[]{TRANSMUTE_CATEGORY.getRecipeType()});
    }

    private void addReactionFlaskRecipes(IRecipeRegistration registration) {
        ItemStack result_flask = ((ReactionFlaskItem)((Object)Registration.REACTION_FLASK_ITEM.get())).m_7968_();
        ReactionFlaskItem.Contents empty_contents = new ReactionFlaskItem.Contents(Map.of(), false);
        empty_contents.saveToStack(result_flask);
        ItemStack result_flask_charged = result_flask.m_41777_();
        ReactionFlaskItem.Contents charged_contents = new ReactionFlaskItem.Contents(Map.of(), true);
        charged_contents.saveToStack(result_flask_charged);
        registration.addRecipes(RecipeTypes.CRAFTING, List.of(new ShapedRecipe(ReactiveMod.location("single_flask_craft"), "reactive:special_crafting_recipe_flask", CraftingBookCategory.MISC, 3, 3, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.INERT_CRYSTAL.get()}), Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.m_204132_(AlchemyTags.powerBottles), Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.GOLD_THREAD.get()}), Ingredient.f_43901_}), result_flask), new ShapedRecipe(ReactiveMod.location("two_flask_craft"), "reactive:special_crafting_recipe_flask", CraftingBookCategory.MISC, 3, 3, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.INERT_CRYSTAL.get()}), Ingredient.f_43901_, Ingredient.m_204132_(AlchemyTags.powerBottles), Ingredient.m_204132_(AlchemyTags.powerBottles), Ingredient.f_43901_, Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.GOLD_THREAD.get()}), Ingredient.f_43901_}), result_flask), new ShapedRecipe(ReactiveMod.location("three_flask_craft"), "reactive:special_crafting_recipe_flask", CraftingBookCategory.MISC, 3, 3, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.INERT_CRYSTAL.get()}), Ingredient.f_43901_, Ingredient.m_204132_(AlchemyTags.powerBottles), Ingredient.m_204132_(AlchemyTags.powerBottles), Ingredient.m_204132_(AlchemyTags.powerBottles), Ingredient.f_43901_, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.GOLD_THREAD.get()}), Ingredient.f_43901_}), result_flask), new ShapelessRecipe(ReactiveMod.location("special_crafting_recipe_flask"), "special_crafting_recipe_flask", CraftingBookCategory.MISC, result_flask_charged, NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{result_flask}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.VOLT_CELL.get()})}))));
    }

    private void addMaterialRecipes(IRecipeRegistration registration) {
        ItemStack salt_material_example = ((MaterialItem)((Object)Registration.MATERIAL_ITEM.get())).m_7968_();
        MaterialItem.setMaterialId(salt_material_example, ReactiveMod.location("example_salt"));
        ItemStack adept_salt_material_example = ((MaterialItem)((Object)Registration.MATERIAL_ITEM.get())).m_7968_();
        MaterialItem.setMaterialId(adept_salt_material_example, ReactiveMod.location("example_adept_salt"));
        ItemStack creation_salt_material_example = ((MaterialItem)((Object)Registration.MATERIAL_ITEM.get())).m_7968_();
        MaterialItem.setMaterialId(creation_salt_material_example, ReactiveMod.location("example_creation_salt"));
        ItemStack wool_material_example = ((MaterialItem)((Object)Registration.MATERIAL_ITEM.get())).m_7968_();
        MaterialItem.setMaterialId(wool_material_example, ReactiveMod.location("example_wool"));
        registration.addRecipes(TRANSMUTE_CATEGORY.getRecipeType(), List.of(new TransmuteRecipe(ReactiveMod.location("material_crafting_demo.salt"), "material_crafting_demo", Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.SALT_BLOCK.get()}), salt_material_example, List.of((Power)Powers.MIND_POWER.get()), 10, 10, false), new TransmuteRecipe(ReactiveMod.location("material_crafting_demo.adept_salt"), "material_crafting_demo", Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.ADEPT_SALT_BLOCK.get()}), adept_salt_material_example, List.of((Power)Powers.SOUL_POWER.get()), 10, 10, false), new TransmuteRecipe(ReactiveMod.location("material_crafting_demo.creation_salt"), "material_crafting_demo", Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Registration.CREATION_SALT_BLOCK.get()}), creation_salt_material_example, List.of((Power)Powers.WARP_POWER.get()), 10, 10, false), new TransmuteRecipe(ReactiveMod.location("material_crafting_demo.wool"), "material_crafting_demo", Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41870_}), wool_material_example, List.of((Power)Powers.LIGHT_POWER.get()), 10, 10, false)));
    }

    static {
        DISSOLVE_CATEGORY = new DissolveRecipeCategory();
        TRANSMUTE_CATEGORY = new TransmuteRecipeCategory();
        POWER_BOTTLE_CATEGORY = new PowerBottleRecipeCategory();
        POWER_TYPE = new PowerIngredientType();
        POWER_HANDLER = new PowerIngredientHandler();
        POWER_RENDERER = new PowerIngredientRenderer();
    }
}

