/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.client.renderers.rxn.ReactionRenderer;
import dev.hyperlynx.reactive.integration.kubejs.ReactiveKubeJSPlugin;
import dev.hyperlynx.reactive.integration.kubejs.events.CustomReactionTickEventJS;
import dev.hyperlynx.reactive.integration.kubejs.events.EventTransceiver;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;

public class CustomReaction
extends Reaction {
    protected int cost = 0;
    protected int yield = 0;
    protected Optional<Power> output_power = Optional.empty();

    public CustomReaction(String alias, List<Power> required_powers, MutableComponent name_override) {
        super(alias, 0);
        for (Power required_power : required_powers) {
            this.reagents.put(required_power, WorldSpecificValue.get(alias + required_power + "required", 1, 400));
        }
        this.name = name_override;
    }

    public static ReactionRenderer getRenderFunction(String alias) {
        return reactor -> EventTransceiver.CUSTOM_REACTION_RENDER_EVENT.post((EventJS)new CustomReactionTickEventJS(alias, reactor));
    }

    @Override
    public Reaction.Status conditionsMet(Reactor crucible) {
        Reaction.Status status = super.conditionsMet(crucible);
        if (!status.equals((Object)Reaction.Status.REACTING)) {
            return status;
        }
        CustomReactionTickEventJS event = new CustomReactionTickEventJS(this.getAlias(), crucible);
        EventResult result = ReactiveKubeJSPlugin.REACTION_EFFECT_CACHE.processServerTestEvent(event);
        if (result.interruptFalse()) {
            return Reaction.Status.INHIBITED;
        }
        return status;
    }

    @Override
    public void run(Reactor crucible) {
        EventTransceiver.CUSTOM_REACTION_RUN_EVENT.post((ScriptTypeHolder)ScriptType.SERVER, (EventJS)new CustomReactionTickEventJS(this.getAlias(), crucible));
        if (this.cost > 0) {
            this.expendPower(crucible, this.cost);
        }
        this.output_power.ifPresent(power -> crucible.addPower((Power)power, this.yield));
        super.run(crucible);
    }

    private void expendPower(Reactor crucible, int cost) {
        for (Power p : this.getReagents().keySet()) {
            crucible.expendPower(p, (int)((double)cost / (double)this.getReagents().size()) + 1);
            crucible.setDirty();
        }
    }
}

