/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.integration.kubejs;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.material.BuiltInMaterials;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialModel;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.Formula;
import dev.hyperlynx.reactive.alchemy.material.formula.MaterialFormulaMaps;
import dev.hyperlynx.reactive.integration.kubejs.KubeScriptException;
import dev.hyperlynx.reactive.util.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public class MaterialFactory {
    private final BuiltInMaterials.BuiltInMaterialEvent event;
    private final ResourceLocation id;
    private String name = "";
    private final Map<MaterialProperty<?>, Object> properties = new HashMap();
    private final Map<Power, Integer> power_costs = new HashMap<Power, Integer>();
    private Item base_material;

    public MaterialFactory(BuiltInMaterials.BuiltInMaterialEvent event, ResourceLocation id) {
        this.event = event;
        this.id = id;
    }

    public MaterialFactory defaultName(String name) {
        this.name = name;
        return this;
    }

    public MaterialFactory model(String model) {
        if (!MaterialModel.isNameValid(model)) {
            ReactiveMod.LOGGER.error("KubeJS script used invalid material model.");
            ReactiveMod.LOGGER.error("Valid models include {}", ((Stream)Arrays.stream(MaterialModel.values()).sequential()).map(MaterialModel::m_7912_).toList());
            throw new KubeScriptException("Model '" + model + "' was invalid.");
        }
        this.properties.put((MaterialProperty)MaterialProperties.MODEL_NAME.get(), model);
        return this;
    }

    public MaterialFactory color(int hex) {
        if (hex < 0 || hex > 0xFFFFFF) {
            throw new KubeScriptException("Invalid RBG color! Did you mistype?");
        }
        this.properties.put((MaterialProperty)MaterialProperties.COLOR.get(), new Color(hex));
        return this;
    }

    public MaterialFactory light(int light) {
        if (light < 0 || light > 15) {
            throw new KubeScriptException("Can't set light to a value outside of [0, 15]!");
        }
        this.properties.put((MaterialProperty)MaterialProperties.LIGHT.get(), light);
        return this;
    }

    public MaterialFactory flammability(int flammability) {
        if (flammability < 0 || flammability > 300) {
            throw new KubeScriptException("Can't set flammability to a value outside of [0, 300]!");
        }
        this.properties.put((MaterialProperty)MaterialProperties.FLAMMABILITY.get(), flammability);
        return this;
    }

    public MaterialFactory redstone(int signal) {
        if (signal < 0 || signal > 15) {
            throw new KubeScriptException("Can't set redstone signal to a value outside of [0, 15]!");
        }
        this.properties.put((MaterialProperty)MaterialProperties.REDSTONE.get(), signal);
        return this;
    }

    public MaterialFactory breakStrength(float strength) {
        this.properties.put((MaterialProperty)MaterialProperties.BREAK_STRENGTH.get(), Float.valueOf(strength));
        return this;
    }

    public MaterialFactory blastResistance(float strength) {
        this.properties.put((MaterialProperty)MaterialProperties.BLAST_RESISTANCE.get(), Float.valueOf(strength));
        return this;
    }

    public MaterialFactory enchantPower(float power) {
        this.properties.put((MaterialProperty)MaterialProperties.ENCHANT_POWER.get(), Float.valueOf(power));
        return this;
    }

    public MaterialFactory friction(float friction) {
        this.properties.put((MaterialProperty)MaterialProperties.FRICTION.get(), Float.valueOf(friction));
        return this;
    }

    public MaterialFactory magmaStep() {
        this.properties.put((MaterialProperty)MaterialProperties.MAGMA_STEP.get(), Unit.INSTANCE);
        return this;
    }

    public MaterialFactory fireSource() {
        this.properties.put((MaterialProperty)MaterialProperties.FIRE_SOURCE.get(), Unit.INSTANCE);
        return this;
    }

    public MaterialFactory warping() {
        this.properties.put((MaterialProperty)MaterialProperties.WARPING.get(), Unit.INSTANCE);
        return this;
    }

    public MaterialFactory redstoneMelting() {
        this.properties.put((MaterialProperty)MaterialProperties.REDSTONE_MELTING.get(), Unit.INSTANCE);
        return this;
    }

    public MaterialFactory selfDefense(float damage) {
        this.properties.put((MaterialProperty)MaterialProperties.SELF_DEFENSE.get(), Float.valueOf(damage));
        return this;
    }

    public MaterialFactory intangible() {
        this.properties.put((MaterialProperty)MaterialProperties.INTANGIBLE.get(), Unit.INSTANCE);
        return this;
    }

    public MaterialFactory semitangible() {
        this.properties.put((MaterialProperty)MaterialProperties.SEMITANGIBLE.get(), Unit.INSTANCE);
        return this;
    }

    public MaterialFactory formulaBase(ResourceLocation item_id) {
        Item base = (Item)ForgeRegistries.ITEMS.getValue(item_id);
        if (base == null) {
            throw new KubeScriptException("Invalid item id " + item_id);
        }
        if (!MaterialFormulaMaps.BASE_YIELDS.containsKey(item_id)) {
            throw new KubeScriptException("This item is not a registered material base");
        }
        this.base_material = base;
        return this;
    }

    public MaterialFactory addFormulaCost(String reagent, int cost) {
        this.power_costs.put((Power)Powers.POWER_SUPPLIER.get().getValue(ResourceLocation.parse((String)reagent)), cost);
        return this;
    }

    public void build() {
        Material material = this.base_material != null && !this.power_costs.isEmpty() ? new Material(this.properties, this.name, new Formula(this.power_costs, this.base_material), null, "") : new Material(this.properties, this.name, null, null, "");
        this.event.addMaterial(this.id, material);
    }
}

