/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.ClientMaterialMan;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.MaterialModel;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.Formula;
import dev.hyperlynx.reactive.util.Color;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class MaterialItem
extends BlockItem {
    public static final String MATERIAL_ID_KEY = "MaterialId";
    private static final int MAX_NOTES_TOOLTIP_LINE_LENGTH = 32;

    public MaterialItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static boolean hasMaterialId(ItemStack stack) {
        return stack.m_41782_() && stack.m_41784_().m_128441_(MATERIAL_ID_KEY);
    }

    public static void setMaterialId(ItemStack stack, ResourceLocation id) {
        stack.m_41784_().m_128359_(MATERIAL_ID_KEY, id.toString());
    }

    public static void removeMaterialId(ItemStack stack) {
        stack.m_41749_(MATERIAL_ID_KEY);
    }

    @Nullable
    public static ResourceLocation getMaterialId(ItemStack stack) {
        if (MaterialItem.hasMaterialId(stack)) {
            return ResourceLocation.parse((String)stack.m_41784_().m_128461_(MATERIAL_ID_KEY));
        }
        return null;
    }

    public Component m_7626_(ItemStack stack) {
        if (MaterialItem.hasMaterialId(stack)) {
            return ClientMaterialMan.getName(Objects.requireNonNull(MaterialItem.getMaterialId(stack)));
        }
        return Component.m_237115_((String)"block.reactive.invalid_material");
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        Component discoverer;
        Object first_notes_line;
        super.m_7373_(stack, level, components, flag);
        if (!MaterialItem.hasMaterialId(stack)) {
            components.add((Component)Component.m_237115_((String)"text.reactive.random_material_tooltip"));
            return;
        }
        Material material = MaterialMan.fetch(level, MaterialItem.getMaterialId(stack));
        if (!material.getNotes().isEmpty() && !((String)(first_notes_line = material.getNotes().lines().findFirst().orElse(""))).isEmpty()) {
            if (((String)first_notes_line).length() > 32) {
                first_notes_line = ((String)first_notes_line).substring(0, 32);
                first_notes_line = (String)first_notes_line + "...";
            }
            components.add((Component)Component.m_237113_((String)first_notes_line).m_130940_(ChatFormatting.GRAY));
        }
        if (!(discoverer = material.getDiscovererName(level)).equals(Component.m_237119_())) {
            components.add(discoverer);
        }
        if (flag.m_7050_()) {
            components.add((Component)Component.m_237113_((String)("" + MaterialItem.getMaterialId(stack))).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public static int getItemColor(ItemStack stack, int ignored) {
        if (MaterialItem.hasMaterialId(stack)) {
            return ClientMaterialMan.data().get(MaterialItem.getMaterialId(stack)).getOrDefault((MaterialProperty)MaterialProperties.COLOR.get(), Color.white()).hex();
        }
        return 0;
    }

    public static float getModelOverrideValue(ItemStack stack, Level level, LivingEntity ignored, long ignoredSeed) {
        if (!MaterialItem.hasMaterialId(stack)) {
            return 0.0f;
        }
        Material material = MaterialMan.fetch(level, MaterialItem.getMaterialId(stack));
        return MaterialModel.fromName(material.getOrDefault((MaterialProperty)MaterialProperties.MODEL_NAME.get(), "SALT")).getModelIndex();
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        ResourceLocation id;
        if (level.m_5776_()) {
            return;
        }
        if (!MaterialItem.hasMaterialId(stack)) {
            ResourceLocation random_material_id = MaterialMan.createOrFetchByFormula(level, new Formula(Power.generateRandomPowerCombo(level), (Item)Registration.SALT_BLOCK_ITEM.get()));
            MaterialItem.setMaterialId(stack, random_material_id);
        }
        if (!MaterialMan.occupied(level, id = MaterialItem.getMaterialId(stack))) {
            MaterialItem.removeMaterialId(stack);
        }
    }
}

