/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.blocks.AirLightBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.items.StaffItem;
import dev.hyperlynx.reactive.particles.EnergyParticleOptions;
import dev.hyperlynx.reactive.util.BeamHelper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class StaffEffects {
    public static void radiance(Player user) {
        int range = (Integer)ConfigMan.COMMON.lightStaffRange.get();
        BlockHitResult block_hit = BeamHelper.playerRayTrace(user.m_9236_(), user, ClipContext.Fluid.NONE, ClipContext.Block.VISUAL, range);
        BlockPos block_hit_pos = block_hit.m_82425_();
        Vec3 start = user.m_146892_();
        Vec3 end = start.m_82549_(user.m_20154_().m_82490_((double)range));
        EntityHitResult entity_hit = ProjectileUtil.m_37287_((Entity)user, (Vec3)start, (Vec3)end, (AABB)new AABB(start, end), e -> e instanceof LivingEntity, (double)Double.MAX_VALUE);
        if (user instanceof ServerPlayer) {
            Entity entity;
            if (entity_hit != null && (entity = entity_hit.m_82443_()) instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)entity;
                if (victim.m_6336_().equals(MobType.f_21641_)) {
                    victim.m_7311_(300);
                    victim.m_6469_(user.m_269291_().m_269387_(), StaffItem.getDamageAmount((LivingEntity)user, ((Double)ConfigMan.COMMON.lightStaffPowerVsUndead.get()).floatValue()));
                }
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 40, 0));
            }
            if (!block_hit.m_6662_().equals((Object)HitResult.Type.MISS)) {
                BlockPos light_target = block_hit_pos.m_5484_(block_hit.m_82434_(), 1);
                if (!user.m_9236_().m_46749_(light_target)) {
                    return;
                }
                if (user.m_9236_().m_8055_(light_target).m_60795_() && !user.m_9236_().m_8055_(light_target).m_60713_((Block)Registration.GLOWING_AIR.get())) {
                    user.m_9236_().m_7731_(light_target, (BlockState)((Block)Registration.GLOWING_AIR.get()).m_49966_().m_61124_((Property)AirLightBlock.DECAYING, (Comparable)Boolean.valueOf((Boolean)ConfigMan.COMMON.lightStaffLightsPermanent.get() == false)), 11);
                } else if (user.m_9236_().m_8055_(light_target).m_60713_(Blocks.f_49990_)) {
                    user.m_9236_().m_7731_(light_target, (BlockState)((BlockState)((Block)Registration.GLOWING_AIR.get()).m_49966_().m_61124_((Property)AirLightBlock.DECAYING, (Comparable)Boolean.valueOf((Boolean)ConfigMan.COMMON.lightStaffLightsPermanent.get() == false))).m_61124_((Property)AirLightBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)), 11);
                }
                user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11737_, SoundSource.PLAYERS, 0.4f, 1.2f);
            }
        } else {
            ParticleScribe.drawParticleLine(user.m_9236_(), (ParticleOptions)ParticleTypes.f_123810_, user.m_146892_().f_82479_, user.m_146892_().f_82480_ - 0.4, user.m_146892_().f_82481_, block_hit.m_82450_().f_82479_, block_hit.m_82450_().f_82480_, block_hit.m_82450_().f_82481_, 2, 0.1);
        }
    }

    public static void blazing(Player user) {
        int range = (Integer)ConfigMan.COMMON.blazeStaffRange.get();
        Vec3 start = user.m_146892_();
        Vec3 end = start.m_82549_(user.m_20154_().m_82490_((double)range));
        EntityHitResult entityHit = ProjectileUtil.m_37287_((Entity)user, (Vec3)start, (Vec3)end, (AABB)new AABB(start, end), e -> e instanceof LivingEntity, (double)Double.MAX_VALUE);
        if (user instanceof ServerPlayer) {
            Vec3 target = entityHit == null ? end : entityHit.m_82450_();
            Vec3 fireball_position = start.m_82549_(user.m_20154_().m_82490_(1.5)).m_82520_(user.m_9236_().f_46441_.m_188500_() * 2.0 - 1.0, user.m_9236_().f_46441_.m_188500_() * 2.0 - 1.0, user.m_9236_().f_46441_.m_188500_() * 2.0 - 1.0);
            Vec3 aim = target.m_82546_(fireball_position).m_82541_().m_82490_(0.1);
            Object fireball = (Integer)ConfigMan.COMMON.blazeStaffExplosionSize.get() > 0 ? new LargeFireball(user.m_9236_(), (LivingEntity)user, aim.f_82479_, aim.f_82480_, aim.f_82481_, ((Integer)ConfigMan.COMMON.blazeStaffExplosionSize.get()).intValue()) : new SmallFireball(user.m_9236_(), (LivingEntity)user, aim.f_82479_, aim.f_82480_, aim.f_82481_);
            fireball.m_146884_(fireball_position);
            user.m_9236_().m_7967_((Entity)fireball);
            user.m_9236_().m_6263_(null, fireball_position.f_82479_, fireball_position.f_82480_, fireball_position.f_82481_, SoundEvents.f_11874_, SoundSource.PLAYERS, 0.25f, 1.0f);
        }
    }

    public static void spectral(Player user) {
        BlockHitResult blockHit = BeamHelper.playerRayTrace(user.m_9236_(), user, ClipContext.Fluid.NONE, ClipContext.Block.COLLIDER, ((Integer)ConfigMan.COMMON.soulStaffRange.get()).intValue());
        Vec3 blockHitPos = blockHit.m_82450_();
        AABB aoe = new AABB(blockHitPos.m_82492_(1.0, 1.0, 1.0), blockHitPos.m_82520_(1.0, 1.0, 1.0));
        boolean wide = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)Registration.WIDE_RANGE.get()), (LivingEntity)user) > 0;
        aoe = aoe.m_82400_(wide ? 2.5 : 1.5);
        if (user instanceof ServerPlayer) {
            for (LivingEntity victim : user.m_9236_().m_45976_(LivingEntity.class, aoe)) {
                if (victim instanceof ServerPlayer && !victim.equals((Object)user) && !CrystalIronItem.effectNotBlocked(victim, 1)) continue;
                victim.m_6469_(user.m_269291_().m_269425_(), StaffItem.getDamageAmount((LivingEntity)user, ((Double)ConfigMan.COMMON.soulStaffPower.get()).floatValue()));
                victim.m_147240_(0.3, user.m_9236_().f_46441_.m_188500_() * 0.2 - 0.1, user.m_9236_().f_46441_.m_188500_() * 0.2 - 0.1);
            }
            user.m_9236_().m_6263_(null, blockHitPos.f_82479_, blockHitPos.f_82480_, blockHitPos.f_82481_, SoundEvents.f_12404_, SoundSource.PLAYERS, 0.5f, user.m_9236_().f_46441_.m_188501_() * 0.1f + 0.95f);
        } else {
            ParticleScribe.drawParticleBox(user.m_9236_(), (ParticleOptions)ParticleTypes.f_123746_, aoe, 10);
            user.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, blockHitPos.f_82479_, blockHitPos.f_82480_, blockHitPos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static void missile(Player user) {
        if (user instanceof ServerPlayer) {
            AABB aoe = new AABB(user.m_20182_().m_82492_(1.0, 1.0, 1.0), user.m_20182_().m_82520_(1.0, 1.0, 1.0));
            boolean super_missile = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)Registration.WIDE_RANGE.get()), (LivingEntity)user) > 0;
            int base_range = (Integer)ConfigMan.COMMON.mindStaffRange.get();
            aoe = aoe.m_82400_(super_missile ? (double)base_range * 1.67 : (double)base_range);
            List nearby_ents = user.m_9236_().m_45976_(LivingEntity.class, aoe);
            nearby_ents.remove(user);
            HashMap<LivingEntity, Integer> hit_counts = new HashMap<LivingEntity, Integer>();
            for (int i = 0; i < (super_missile ? (Integer)ConfigMan.COMMON.mindStaffEnchantedMissiles.get() : (Integer)ConfigMan.COMMON.mindStaffBaseMissiles.get()) && !nearby_ents.isEmpty(); ++i) {
                TamableAnimal tamable_victim;
                LivingEntity victim = (LivingEntity)nearby_ents.get(user.m_9236_().f_46441_.m_216339_(0, nearby_ents.size()));
                if (victim.m_21224_() || victim instanceof ArmorStand || victim instanceof TamableAnimal && (tamable_victim = (TamableAnimal)victim).m_269323_() != null && tamable_victim.m_269323_().equals((Object)user)) continue;
                hit_counts.put(victim, hit_counts.getOrDefault(victim, 0) + 1);
                if ((Integer)hit_counts.get(victim) < (Integer)ConfigMan.COMMON.mindStaffMaxHits.get()) continue;
                nearby_ents.remove(victim);
            }
            for (LivingEntity victim : hit_counts.keySet()) {
                for (int i = 0; i < (Integer)hit_counts.get(victim); ++i) {
                    ParticleScribe.drawParticleZigZag(user.m_9236_(), (ParticleOptions)Registration.SMALL_RUNE_PARTICLE, user.m_20185_(), user.m_20188_() - 0.4, user.m_20189_(), victim.m_20185_(), victim.m_20188_(), victim.m_20189_(), 2, 5, 0.7);
                    user.m_9236_().m_6263_(null, victim.m_20185_(), victim.m_20188_(), victim.m_20189_(), SoundEvents.f_144049_, SoundSource.PLAYERS, 0.3f, user.m_9236_().f_46441_.m_188501_() * 0.1f + 0.8f);
                }
                float damage = (float)((Integer)hit_counts.get(victim)).intValue() * ((Double)ConfigMan.COMMON.mindStaffPower.get()).floatValue();
                victim.m_6469_(user.m_269291_().m_269425_(), StaffItem.getDamageAmount((LivingEntity)user, damage));
            }
        }
    }

    public static void living(Player user) {
        AABB aoe = new AABB(user.m_20182_().m_82492_(1.0, 1.0, 1.0), user.m_20182_().m_82520_(1.0, 1.0, 1.0));
        aoe = aoe.m_82400_((double)((Integer)ConfigMan.COMMON.vitalStaffRange.get()).intValue());
        if ((double)user.m_9236_().f_46441_.m_188501_() < 0.4) {
            List nearby_ents = user.m_9236_().m_45976_(LivingEntity.class, aoe);
            for (LivingEntity victim : nearby_ents) {
                boolean has_regen = false;
                boolean has_hp_up = false;
                for (MobEffectInstance mei : victim.m_21220_()) {
                    if (mei.m_19544_().equals(MobEffects.f_19616_)) {
                        mei.m_19558_(new MobEffectInstance(MobEffects.f_19616_, 500, (Integer)ConfigMan.COMMON.vitalStaffHealthBoost.get() - 1));
                        has_hp_up = true;
                        continue;
                    }
                    if (!mei.m_19544_().equals(MobEffects.f_19605_)) continue;
                    mei.m_19558_(new MobEffectInstance(MobEffects.f_19605_, 50, (Integer)ConfigMan.COMMON.vitalStaffRegeneration.get() - 1));
                    has_regen = true;
                }
                if (!has_hp_up) {
                    victim.m_7292_(new MobEffectInstance(MobEffects.f_19616_, 500, (Integer)ConfigMan.COMMON.vitalStaffHealthBoost.get() - 1));
                }
                if (has_regen) continue;
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 50, (Integer)ConfigMan.COMMON.vitalStaffRegeneration.get() - 1));
            }
        }
        ParticleScribe.drawParticleBox(user.m_9236_(), (ParticleOptions)new EnergyParticleOptions(0.1f, ((Power)Powers.VITAL_POWER.get()).getColor(), user.m_146892_(), (double)user.m_9236_().f_46441_.m_188501_() > 0.2, true), aoe.m_82406_(3.0), 5);
        user.m_9236_().m_6263_(null, user.m_20185_(), user.m_20186_(), user.m_20189_(), SoundEvents.f_11737_, SoundSource.PLAYERS, 0.7f, 1.3f);
    }
}

