/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.items;

import com.mojang.serialization.DynamicOps;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.items.PowerBottleItem;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class WarpBottleItem
extends PowerBottleItem {
    public static final String TAG_TELEPORT_DESTINATION = "TeleportPos";
    public static final String TAG_TELEPORT_DIMENSION = "TeleportDimension";

    public WarpBottleItem(Item.Properties props, Block block) {
        super(props, block);
    }

    public static ItemStack makeRiftBottle(CrucibleBlockEntity c, ItemStack bottle) {
        c.enderRiftStrength = 0;
        return WarpBottleItem.makeRiftBottle(bottle, (ResourceKey<Level>)Objects.requireNonNull(c.obtainLevel()).m_46472_(), c.m_58899_());
    }

    public static ItemStack makeRiftBottle(ItemStack bottle, ResourceKey<Level> dimension, BlockPos destination) {
        if (bottle.m_41783_() == null) {
            bottle.m_41751_(new CompoundTag());
        }
        WarpBottleItem.addTeleportTags(dimension, destination, bottle.m_41783_());
        return bottle;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return WarpBottleItem.isRiftBottle(stack) || super.m_5812_(stack);
    }

    @Override
    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().m_8055_(context.m_8083_()).m_60713_((Block)Registration.DIVINE_SYMBOL.get())) {
            return InteractionResult.FAIL;
        }
        if (WarpBottleItem.isRiftBottle(context.m_43722_())) {
            return InteractionResult.PASS;
        }
        return super.m_6225_(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        if (WarpBottleItem.isRiftBottle(player.m_21120_(hand))) {
            if (WarpBottleItem.attemptWarp(level, player, hand) && !player.m_7500_()) {
                player.m_21008_(hand, ((Item)Registration.QUARTZ_BOTTLE.get()).m_7968_());
            }
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return super.m_7203_(level, player, hand);
    }

    public static boolean attemptWarp(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        GlobalPos destination;
        boolean warp_occurred = false;
        CompoundTag tag = player.m_21120_(hand).m_41783_();
        if (tag != null && level.m_46472_().equals(WarpBottleItem.getTeleportDimension(tag).orElse(null)) && (destination = WarpBottleItem.getTeleportPosition(tag)) != null) {
            if (CrystalIronItem.effectNotBlocked((LivingEntity)player, 1)) {
                player.m_6021_((double)destination.m_122646_().m_123341_() + 0.5, (double)destination.m_122646_().m_123342_() + 0.85, (double)destination.m_122646_().m_123343_() + 0.5);
                level.m_5594_(null, destination.m_122646_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                warp_occurred = true;
                if (player instanceof ServerPlayer) {
                    ServerPlayer splayer = (ServerPlayer)player;
                    CriteriaTriggers.BE_TELEPORTED_TRIGGER.trigger(splayer);
                }
            } else if (!(level instanceof ServerLevel)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.reactive.warp_blocked"), true);
            }
        }
        return warp_occurred;
    }

    public int getMaxStackSize(ItemStack stack) {
        if (WarpBottleItem.isRiftBottle(stack)) {
            return 1;
        }
        return super.getMaxStackSize(stack);
    }

    public static void addTeleportTags(ResourceKey<Level> lkey, BlockPos pos, CompoundTag tag) {
        tag.m_128365_(TAG_TELEPORT_DESTINATION, (Tag)NbtUtils.m_129224_((BlockPos)pos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, lkey).result().ifPresent(dim_key -> tag.m_128365_(TAG_TELEPORT_DIMENSION, dim_key));
    }

    public static boolean isRiftBottle(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41783_();
        return compoundtag != null && compoundtag.m_128441_(TAG_TELEPORT_DESTINATION);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return WarpBottleItem.isRiftBottle(stack) ? Component.m_237115_((String)"item.reactive.linked_warp_bottle") : super.m_7626_(stack);
    }

    private static Optional<ResourceKey<Level>> getTeleportDimension(CompoundTag p_40728_) {
        return Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)p_40728_.m_128423_(TAG_TELEPORT_DIMENSION)).result();
    }

    public static GlobalPos getTeleportPosition(CompoundTag p_220022_) {
        Optional<ResourceKey<Level>> optional;
        boolean flag = p_220022_.m_128441_(TAG_TELEPORT_DESTINATION);
        boolean flag1 = p_220022_.m_128441_(TAG_TELEPORT_DIMENSION);
        if (flag && flag1 && (optional = WarpBottleItem.getTeleportDimension(p_220022_)).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)p_220022_.m_128469_(TAG_TELEPORT_DESTINATION));
            return GlobalPos.m_122643_(optional.get(), (BlockPos)blockpos);
        }
        return null;
    }
}

