/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.util.Color;
import net.minecraft.core.particles.DustParticleOptionsBase;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EnergyParticleOptions
extends DustParticleOptionsBase {
    final float speed;
    final Color color;
    final Vec3 target;
    final boolean reverse_motion;
    public final boolean orbit;
    protected static final MapCodec<EnergyParticleOptions> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("speed").forGetter(EnergyParticleOptions::getSpeed), (App)Color.CODEC.fieldOf("color").forGetter(EnergyParticleOptions::getHyperColor), (App)Vec3.f_231074_.fieldOf("target").forGetter(EnergyParticleOptions::getTarget), (App)Codec.BOOL.fieldOf("reversed").forGetter(EnergyParticleOptions::isReversed), (App)Codec.BOOL.fieldOf("orbit").forGetter(EnergyParticleOptions::isOrbiting)).apply((Applicative)instance, EnergyParticleOptions::new));
    public static final ParticleOptions.Deserializer<EnergyParticleOptions> DESERIALIZER = new ParticleOptions.Deserializer<EnergyParticleOptions>(){

        public EnergyParticleOptions fromCommand(ParticleType<EnergyParticleOptions> type, StringReader reader) throws CommandSyntaxException {
            try {
                return new EnergyParticleOptions(reader.readFloat(), new Color(reader.readInt()), new Vec3(reader.readDouble(), reader.readDouble(), reader.readDouble()), reader.readBoolean(), reader.readBoolean());
            }
            catch (Exception e) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherParseException().create((Object)e);
            }
        }

        public EnergyParticleOptions fromNetwork(ParticleType<EnergyParticleOptions> type, FriendlyByteBuf buf) {
            return new EnergyParticleOptions(buf.readFloat(), new Color(buf.readInt()), new Vec3(buf.m_269394_()), buf.readBoolean(), buf.readBoolean());
        }
    };

    public EnergyParticleOptions(Color color, Vec3 target) {
        this(0.05f, color, target);
    }

    public EnergyParticleOptions(float speed, Color color, Vec3 target) {
        this(speed, color, target, false);
    }

    public EnergyParticleOptions(float speed, Color color, Vec3 target, boolean reverse) {
        this(speed, color, target, reverse, false);
    }

    public EnergyParticleOptions(float speed, Color color, Vec3 target, boolean reverse, boolean orbit) {
        super(color.toVector3f(), 0.1f);
        this.speed = speed;
        this.color = color;
        this.target = target;
        this.reverse_motion = reverse;
        this.orbit = orbit;
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)Registration.ENERGY_PARTICLE_TYPE.get();
    }

    private Color getHyperColor() {
        return this.color;
    }

    public float getSpeed() {
        return this.speed;
    }

    public Vec3 getTarget() {
        return this.target;
    }

    public boolean isReversed() {
        return this.reverse_motion;
    }

    private boolean isOrbiting() {
        return this.orbit;
    }

    public void m_7711_(@NotNull FriendlyByteBuf buffer) {
        buffer.writeFloat(this.speed);
        buffer.writeInt(this.color.hex());
        buffer.m_269582_(this.target.m_252839_());
        buffer.writeBoolean(this.reverse_motion);
        buffer.writeBoolean(this.orbit);
    }

    @NotNull
    public String m_5942_() {
        return this.speed + ";" + this.color.hex() + ";" + this.target + ";" + (this.reverse_motion ? "Reversed" : " ") + ";" + (this.orbit ? "Orbit" : " ");
    }

    public static class Type
    extends ParticleType<EnergyParticleOptions> {
        public Type() {
            super(false, DESERIALIZER);
        }

        @NotNull
        public Codec<EnergyParticleOptions> m_7652_() {
            return CODEC.codec();
        }
    }
}

