/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.recipes;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.items.ReactionFlaskItem;
import dev.hyperlynx.reactive.util.VirtualCraftingContainer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ReactionFlaskCraftingRecipe
extends CustomRecipe {
    public static final TagKey<Item> POWER_BOTTLE_TAG = ItemTags.create((ResourceLocation)ReactiveMod.location("power_bottles"));

    public ReactionFlaskCraftingRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    private static Map<Power, Integer> getPowerBalance(CraftingContainer input) {
        HashMap<Power, Integer> powers = new HashMap<Power, Integer>();
        for (ItemStack stack : input.m_280657_()) {
            for (Power power : Powers.POWER_SUPPLIER.get().getValues()) {
                if (!power.matchesBottle(stack)) continue;
                powers.put(power, WorldSpecificValues.BOTTLE_RETURN.get());
            }
        }
        return powers;
    }

    private boolean matchOneWide(CraftingContainer input) {
        if (!input.m_8020_(0).m_150930_((Item)Registration.INERT_CRYSTAL.get()) || !input.m_8020_(6).m_150930_((Item)Registration.GOLD_THREAD.get())) {
            return false;
        }
        return input.m_8020_(3).m_204117_(POWER_BOTTLE_TAG);
    }

    private boolean matchTwoWide(CraftingContainer input) {
        if (!(input.m_8020_(0).m_150930_((Item)Registration.INERT_CRYSTAL.get()) && input.m_8020_(6).m_150930_((Item)Registration.GOLD_THREAD.get()) || input.m_8020_(1).m_150930_((Item)Registration.INERT_CRYSTAL.get()) && input.m_8020_(7).m_150930_((Item)Registration.GOLD_THREAD.get()))) {
            return false;
        }
        return input.m_8020_(3).m_204117_(POWER_BOTTLE_TAG) && input.m_8020_(4).m_204117_(POWER_BOTTLE_TAG);
    }

    private boolean matchThreeWide(CraftingContainer input) {
        if (!input.m_8020_(1).m_150930_((Item)Registration.INERT_CRYSTAL.get()) || !input.m_8020_(7).m_150930_((Item)Registration.GOLD_THREAD.get())) {
            return false;
        }
        return input.m_8020_(3).m_204117_(POWER_BOTTLE_TAG) && input.m_8020_(4).m_204117_(POWER_BOTTLE_TAG) && input.m_8020_(5).m_204117_(POWER_BOTTLE_TAG);
    }

    private int calculateWidth(CraftingContainer input) {
        int width = 0;
        if (!(input.m_8020_(0).m_41619_() && input.m_8020_(3).m_41619_() && input.m_8020_(6).m_41619_())) {
            ++width;
        }
        if (!(input.m_8020_(1).m_41619_() && input.m_8020_(4).m_41619_() && input.m_8020_(7).m_41619_())) {
            ++width;
        }
        if (!(input.m_8020_(2).m_41619_() && input.m_8020_(5).m_41619_() && input.m_8020_(8).m_41619_())) {
            ++width;
        }
        return width;
    }

    private CraftingContainer leftAdjustAndCopy(CraftingContainer input) {
        boolean left_column_is_empty;
        VirtualCraftingContainer copy = new VirtualCraftingContainer(input);
        if (copy.all_empty) {
            return copy;
        }
        boolean bl = left_column_is_empty = copy.m_8020_(0).m_41619_() && copy.m_8020_(3).m_41619_() && copy.m_8020_(6).m_41619_();
        while (left_column_is_empty) {
            copy.m_6836_(0, copy.m_8020_(1));
            copy.m_6836_(3, copy.m_8020_(4));
            copy.m_6836_(6, copy.m_8020_(7));
            copy.m_6836_(1, copy.m_8020_(2));
            copy.m_6836_(4, copy.m_8020_(5));
            copy.m_6836_(7, copy.m_8020_(8));
            copy.m_6836_(2, ItemStack.f_41583_);
            copy.m_6836_(5, ItemStack.f_41583_);
            copy.m_6836_(8, ItemStack.f_41583_);
            left_column_is_empty = copy.m_8020_(0).m_41619_() && copy.m_8020_(3).m_41619_() && copy.m_8020_(6).m_41619_();
        }
        return copy;
    }

    public boolean matches(@NotNull CraftingContainer input, @NotNull Level level) {
        if (!this.m_8004_(input.m_39347_(), input.m_39346_())) {
            return false;
        }
        int width = this.calculateWidth(input);
        CraftingContainer adjusted = this.leftAdjustAndCopy(input);
        if (width == 1) {
            return this.matchOneWide(adjusted);
        }
        if (width == 2) {
            return this.matchTwoWide(adjusted);
        }
        if (width == 3) {
            return this.matchThreeWide(adjusted);
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer input, @NotNull RegistryAccess pRegistryAccess) {
        Map<Power, Integer> powers = ReactionFlaskCraftingRecipe.getPowerBalance(input);
        ItemStack result = ((ReactionFlaskItem)((Object)Registration.REACTION_FLASK_ITEM.get())).m_7968_();
        ReactionFlaskItem.Contents contents = new ReactionFlaskItem.Contents(powers, false);
        contents.saveToStack(result);
        return result;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer input) {
        boolean already_removed_one_bottle = false;
        NonNullList filtered_remaining_items = NonNullList.m_122779_();
        for (ItemStack stack : super.m_7457_((Container)input)) {
            if (!already_removed_one_bottle && stack.m_150930_((Item)Registration.QUARTZ_BOTTLE.get())) {
                already_removed_one_bottle = true;
                filtered_remaining_items.add((Object)ItemStack.f_41583_);
                continue;
            }
            filtered_remaining_items.add((Object)stack);
        }
        return filtered_remaining_items;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)Registration.REACTION_FLASK_RECIPE_SERIALIZER.get();
    }
}

