/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.util;

import dev.hyperlynx.reactive.ConfigMan;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AreaMemory {
    BlockPos hostPos;
    Map<Block, BlockPos> model;
    Map<TagKey<Block>, BlockPos> tag_model;
    BlockPos block_above_model;

    public AreaMemory(BlockPos hostPos) {
        this.hostPos = hostPos;
        this.model = new HashMap<Block, BlockPos>();
        this.tag_model = new HashMap<TagKey<Block>, BlockPos>();
    }

    public boolean exists(Level l, Block target) {
        return this.fetch(l, target) != null;
    }

    public BlockPos fetch(Level l, Block target) {
        BlockPos holder;
        if (this.model.containsKey(target) && l.m_8055_(holder = this.model.get(target)).m_60713_(target)) {
            return holder;
        }
        BlockPos newlyFound = this.findAndAddNearest(l, (int)((Integer)ConfigMan.COMMON.areaMemoryRange.get()), target);
        if (newlyFound != null) {
            this.model.put(target, newlyFound);
        }
        return newlyFound;
    }

    public BlockPos fetch(Level l, int radius, TagKey<Block> target) {
        BlockPos holder;
        if (this.tag_model.containsKey(target) && l.m_8055_(holder = this.tag_model.get(target)).m_204336_(target)) {
            return holder;
        }
        BlockPos newlyFound = this.findAndAddNearest(l, radius, target);
        if (newlyFound != null) {
            this.tag_model.put(target, newlyFound);
        }
        return newlyFound;
    }

    private BlockPos findAndAddNearest(Level l, int radius, Block target) {
        Optional found_maybe = BlockPos.m_121930_((BlockPos)this.hostPos, (int)radius, (int)radius, blockPos -> l.m_8055_(blockPos).m_60713_(target));
        return found_maybe.orElse(null);
    }

    private BlockPos findAndAddNearest(Level l, int radius, TagKey<Block> target) {
        Optional found_maybe = BlockPos.m_121930_((BlockPos)this.hostPos, (int)radius, (int)radius, blockPos -> l.m_8055_(blockPos).m_204336_(target));
        return found_maybe.orElse(null);
    }

    public boolean existsAbove(Level l, int range, Block target) {
        if (this.block_above_model != null && l.m_8055_(this.block_above_model).m_60713_(target)) {
            return true;
        }
        return this.fetchAbove(l, range, target) != null;
    }

    public BlockPos fetchAbove(Level l, int range, Block target) {
        for (int i = 1; i < range; ++i) {
            if (l.m_8055_(this.hostPos.m_6630_(i)).m_60713_(target)) {
                return this.hostPos.m_6630_(i);
            }
            if (!AreaMemory.stateIsBlocking(l.m_8055_(this.hostPos.m_6630_(i)))) continue;
            return null;
        }
        return null;
    }

    public static boolean stateIsBlocking(BlockState state) {
        return !state.m_60795_() && (!(state.m_60734_() instanceof TrapDoorBlock) || (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_) == false);
    }
}

