/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.material.MaterialData;
import dev.hyperlynx.reactive.be.MaterialBlockEntity;
import dev.hyperlynx.reactive.blocks.MaterialBlock;
import dev.hyperlynx.reactive.net.material.MaterialDataSyncRequest;
import dev.hyperlynx.reactive.net.material.MaterialRenameMessage;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reactive", value={Dist.CLIENT})
public class ClientMaterialMan {
    public static AtomicReference<MaterialData> clientside_data;
    private static final AtomicBoolean initialized;
    private static final Semaphore response_ready;
    private static final AtomicBoolean query_active;

    public static MaterialData data() {
        if (initialized.get()) {
            return clientside_data.get();
        }
        if (query_active.get()) {
            ReactiveMod.LOGGER.warn("Multiple threads are requesting material definitions at one time");
        }
        ReactiveMod.LOGGER.debug("Requesting material definitions from server");
        try {
            query_active.set(true);
            Registration.GENERAL_CHANNEL.sendToServer((Object)new MaterialDataSyncRequest());
            boolean got_result = response_ready.tryAcquire(1, 1L, TimeUnit.SECONDS);
            if (got_result) {
                ReactiveMod.LOGGER.debug("Received material definitions from server");
                return clientside_data.get();
            }
            ReactiveMod.LOGGER.error("Timeout while fetching material definitions from the server. Custom materials will not work properly!");
            return MaterialData.empty();
        }
        catch (NullPointerException exception) {
            ReactiveMod.LOGGER.debug("Connection wasn't available, this request failed");
            return MaterialData.empty();
        }
        catch (InterruptedException exception) {
            ReactiveMod.LOGGER.fatal("Client material fetch was interrupted by an outside force. Data will not sync.");
            return MaterialData.empty();
        }
    }

    public static void receiveDataAsync(MaterialData data) {
        clientside_data.set(data);
        initialized.set(true);
        query_active.set(false);
        response_ready.release();
    }

    @SubscribeEvent
    public static void worldLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            initialized.set(false);
            clientside_data.set(MaterialData.empty());
        }
    }

    public static Component getName(ResourceLocation id) {
        if (ClientMaterialMan.clientside_data.get().materials.containsKey(id)) {
            return clientside_data.get().get(id).getNameComponent();
        }
        return Component.m_237115_((String)"block.reactive.invalid_material");
    }

    public static void rename(ResourceLocation material_id, String value) {
        Registration.GENERAL_CHANNEL.sendToServer((Object)new MaterialRenameMessage(material_id, value));
    }

    public static List<ResourceLocation> getKeysInDiscoveryOrder() {
        return ClientMaterialMan.data().materials.keySet().stream().sorted((left_id, right_id) -> ClientMaterialMan.toClampedInt(ClientMaterialMan.data().materials.get(right_id).getDiscoveryTime() - ClientMaterialMan.data().materials.get(left_id).getDiscoveryTime())).toList();
    }

    private static int toClampedInt(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return Math.toIntExact(value);
    }

    public static void handleMaterialBESync(ResourceLocation material_id, BlockPos pos) {
        BlockEntity blockEntity;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        ClientLevel level = (ClientLevel)Minecraft.m_91087_().f_91074_.m_9236_();
        if (!(level.m_8055_(pos).m_60734_() instanceof MaterialBlock)) {
            level.m_7731_(pos, ((MaterialBlock)((Object)Registration.MATERIAL_BLOCK.get())).m_49966_(), 4);
        }
        if ((blockEntity = level.m_7702_(pos)) instanceof MaterialBlockEntity) {
            MaterialBlockEntity mbe = (MaterialBlockEntity)blockEntity;
            mbe.setMaterial((Level)level, material_id);
        }
    }

    static {
        initialized = new AtomicBoolean(false);
        response_ready = new Semaphore(0, false);
        query_active = new AtomicBoolean(false);
    }
}

