/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.material.BuiltInMaterials;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.net.material.MaterialDataSyncMessage;
import dev.hyperlynx.reactive.util.NBTSerializer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class MaterialData
extends SavedData {
    protected final Map<ResourceLocation, Material> materials = BuiltInMaterials.generate();
    public static final int CURRENT_VERSION = 12011;
    private static final NBTSerializer<MaterialData> SERIALIZER_V1 = new NBTSerializer<MaterialData>(){

        public CompoundTag encode(MaterialData data) {
            CompoundTag tag = new CompoundTag();
            for (ResourceLocation id : data.materials().keySet()) {
                tag.m_128365_(id.toString(), Material.SERIALIZER.encode(data.materials.get(id)));
            }
            return tag;
        }

        @Override
        @Nullable
        public MaterialData decode(Tag input) {
            if (input instanceof CompoundTag) {
                CompoundTag compound_input = (CompoundTag)input;
                HashMap<ResourceLocation, Material> materials = new HashMap<ResourceLocation, Material>(compound_input.m_128431_().size());
                for (String key : compound_input.m_128431_()) {
                    try {
                        ResourceLocation id = ResourceLocation.parse((String)key);
                        Material material = Material.SERIALIZER.decode(compound_input.m_128423_(key));
                        materials.put(id, material);
                    }
                    catch (ResourceLocationException exception) {
                        ReactiveMod.LOGGER.error("Error loading material data: incorrect format for id:", (Throwable)exception);
                    }
                }
                MaterialData data = new MaterialData();
                data.materials.putAll(materials);
                return data;
            }
            return null;
        }
    };
    public static final Map<Integer, NBTSerializer<MaterialData>> CODECS_BY_VERSION = Map.of(1201, SERIALIZER_V1);

    public MaterialData() {
    }

    public MaterialData(MaterialData data) {
        this.materials.putAll(data.materials);
    }

    public static MaterialData empty() {
        return new MaterialData();
    }

    private Map<ResourceLocation, Material> materials() {
        return this.materials;
    }

    public Material get(ResourceLocation id) {
        if (this.materials.containsKey(id)) {
            return this.materials.get(id);
        }
        return Material.empty();
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128365_("Data", SERIALIZER_V1.encode(this));
        tag.m_128365_("version", (Tag)IntTag.m_128679_((int)12011));
        return tag;
    }

    public static MaterialData load(CompoundTag tag) {
        int version = 12011;
        if (tag.m_128425_("version", 3)) {
            version = tag.m_128451_("version");
        }
        if (version != 12011) {
            ReactiveMod.LOGGER.info("Attempting to load material data with mismatched version {} (current is {})", (Object)version, (Object)12011);
            if (!CODECS_BY_VERSION.containsKey(version)) {
                ReactiveMod.LOGGER.error("No serializer for this version was found, attempting load with most recent serializer.");
            }
        }
        NBTSerializer<MaterialData> serializer = CODECS_BY_VERSION.getOrDefault(version, SERIALIZER_V1);
        return serializer.decode(tag.m_128423_("Data"));
    }

    public void addMaterial(ResourceLocation id, Material material) {
        this.materials.put(id, material);
        this.m_77762_();
    }

    public void setToEmpty(ResourceLocation id) {
        Material stub = Material.empty();
        stub.setName(Component.m_237115_((String)"text.reactive.material_removed").getString());
        this.materials.put(id, stub);
        this.m_77762_();
    }

    public void reset() {
        this.materials.clear();
        this.m_77762_();
    }

    public void m_77762_() {
        super.m_77762_();
        Registration.GENERAL_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new MaterialDataSyncMessage(new MaterialData(this)));
    }
}

