/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.ClientMaterialMan;
import dev.hyperlynx.reactive.alchemy.material.ColorMaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.IntMaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.Material;
import dev.hyperlynx.reactive.alchemy.material.MaterialData;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.YieldEntry;
import dev.hyperlynx.reactive.alchemy.material.formula.Formula;
import dev.hyperlynx.reactive.alchemy.material.formula.MaterialFormulaMaps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MaterialMan {
    public static MaterialData data(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            return (MaterialData)Objects.requireNonNull(slevel.m_7654_().m_129880_(ServerLevel.f_46428_)).m_8895_().m_164861_(MaterialData::load, MaterialData::empty, "reactive_materials");
        }
        if (level != null && level.m_5776_()) {
            return ClientMaterialMan.data();
        }
        ReactiveMod.LOGGER.debug("Tried to fetch data before ServerLevel was available. Level is {}", (Object)level);
        return MaterialData.empty();
    }

    public static Material fetch(Level level, ResourceLocation id) {
        return MaterialMan.data(level).get(id);
    }

    public static void addMaterial(Level level, ResourceLocation id, Material material) {
        MaterialMan.data(level).addMaterial(id, material);
    }

    public static Map<ResourceLocation, Material> getAll(Level level) {
        return MaterialMan.data((Level)level).materials;
    }

    public static void remove(Level level, ResourceLocation id) {
        MaterialMan.data(level).setToEmpty(id);
    }

    public static void reset(ServerLevel level) {
        MaterialData data = MaterialMan.data((Level)level);
        data.reset();
    }

    public static boolean occupied(Level level, ResourceLocation id) {
        return MaterialMan.data((Level)level).materials.containsKey(id);
    }

    public static void rename(ServerLevel level, Player player, ResourceLocation id, String name) {
        Material material = MaterialMan.data((Level)level).get(id);
        material.setName(name);
        if (!material.wasDiscovered()) {
            material.setDiscoverer(player);
            CriteriaTriggers.DISCOVER_MATERIAL.trigger((ServerPlayer)player);
        }
        MaterialMan.data((Level)level).m_77762_();
    }

    public static ResourceLocation createOrFetchByFormula(Level level, @NotNull Formula formula) {
        for (Map.Entry<ResourceLocation, Material> existing_material : MaterialMan.data((Level)level).materials.entrySet()) {
            if (!existing_material.getValue().formulaMatches(formula)) continue;
            return existing_material.getKey();
        }
        int index = MaterialMan.data((Level)level).materials.size();
        ResourceLocation new_material_id = ResourceLocation.fromNamespaceAndPath((String)"auto", (String)("" + index));
        while (MaterialMan.occupied(level, new_material_id)) {
            new_material_id = ResourceLocation.fromNamespaceAndPath((String)"auto", (String)("" + ++index));
        }
        MaterialMan.addMaterial(level, new_material_id, MaterialMan.generateMaterial(formula));
        ReactiveMod.LOGGER.info("Created new material {}", (Object)new_material_id);
        return new_material_id;
    }

    @NotNull
    public static Material generateMaterial(@NotNull Formula formula) {
        YieldEntry yield = MaterialFormulaMaps.BASE_YIELDS.get(formula.base_material().m_204114_().m_205785_().m_135782_());
        if (yield == null) {
            throw new IllegalStateException("Tried to make a material using a base (" + formula.base_material().m_7626_(formula.base_material().m_7968_()).getString() + ") with no defined yield! This shouldn't have been possible...");
        }
        return new Material(MaterialMan.generateProperties(formula.powers(), yield), "", formula.copy());
    }

    private static Map<MaterialProperty<?>, Object> generateProperties(Map<Power, Integer> input_powers, YieldEntry yield_entry) {
        HashMap properties = new HashMap();
        if (yield_entry.wool()) {
            properties.put((MaterialProperty)MaterialProperties.COLOR.get(), ((ColorMaterialProperty)MaterialProperties.COLOR.get()).instance((Map)input_powers));
            properties.put((MaterialProperty)MaterialProperties.MODEL_NAME.get(), yield_entry.default_model());
            if (((IntMaterialProperty)MaterialProperties.LIGHT.get()).requirementsMet(input_powers)) {
                properties.put((MaterialProperty)MaterialProperties.LIGHT.get(), ((IntMaterialProperty)MaterialProperties.LIGHT.get()).instance((Map)input_powers));
            }
            properties.put((MaterialProperty)MaterialProperties.FLAMMABILITY.get(), 30);
            return properties;
        }
        HashMap<Power, Integer> adjusted_input_powers = new HashMap<Power, Integer>(input_powers);
        adjusted_input_powers.replaceAll((p, v) -> (int)((float)((Integer)adjusted_input_powers.get(p)).intValue() * yield_entry.power_effect_multiplier().floatValue()));
        for (MaterialProperty property : MaterialProperties.PROPERTY_SUPPLIER.get().getValues().stream().toList()) {
            if (!property.requirementsMet(adjusted_input_powers)) continue;
            properties.put(property, property.instance(adjusted_input_powers));
        }
        if (properties.get(MaterialProperties.MODEL_NAME.get()).equals("default")) {
            properties.put((MaterialProperty)MaterialProperties.MODEL_NAME.get(), yield_entry.default_model());
        }
        return properties;
    }
}

