/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.formula.MaterialFormulaMaps;
import dev.hyperlynx.reactive.alchemy.material.formula.PropertyFormulaRequirements;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public abstract class MaterialProperty<T> {
    public boolean requirementsMet(Map<Power, Integer> formula) {
        ResourceLocation id = MaterialProperties.PROPERTY_SUPPLIER.get().getKey((Object)this);
        assert (id != null);
        PropertyFormulaRequirements requirement_map = MaterialFormulaMaps.PROPERTY_FORMULA_MAP.get(id);
        if (requirement_map == null) {
            ReactiveMod.LOGGER.error("No requirement map has been defined for {}", (Object)id);
            return false;
        }
        for (PropertyFormulaRequirements.Part requirement : requirement_map.requirements()) {
            Power power = (Power)Powers.POWER_SUPPLIER.get().getValue(requirement.power_id());
            if (power == null) {
                ReactiveMod.LOGGER.error("Invalid power {} in requirement map for {}", (Object)requirement.power_id(), (Object)id);
                return false;
            }
            if (formula.containsKey(power) && formula.get(power) >= requirement.lowBound(id)) continue;
            return false;
        }
        return true;
    }

    public abstract T instance(Map<Power, Integer> var1);

    protected ResourceLocation getId() {
        return MaterialProperties.PROPERTY_SUPPLIER.get().getKey((Object)this);
    }

    protected String getTagName() {
        ResourceLocation id = this.getId();
        return id.m_135827_() + "_" + id.m_135815_();
    }

    public abstract void save(CompoundTag var1, Object var2);

    public abstract T fromTag(CompoundTag var1);
}

