/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material;

import dev.hyperlynx.reactive.ReactiveMod;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperty;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.MaterialFormulaMaps;
import dev.hyperlynx.reactive.alchemy.material.formula.StringFormulaOutcome;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class StringMaterialProperty
extends MaterialProperty<String> {
    @Override
    public String instance(Map<Power, Integer> formula) {
        ResourceLocation id = MaterialProperties.PROPERTY_SUPPLIER.get().getKey((Object)this);
        assert (id != null);
        List<FormulaOutcome> outcomes = MaterialFormulaMaps.FORMULA_OUTCOME_MAP.get(id);
        if (outcomes == null || outcomes.isEmpty()) {
            ReactiveMod.LOGGER.error("No outcome map has been defined for {}, defaulting to empty string", (Object)id);
            return "";
        }
        for (FormulaOutcome outcome : outcomes) {
            if (!(outcome instanceof StringFormulaOutcome)) {
                ReactiveMod.LOGGER.error("Outcome map for {} has a non-applicable outcome type set, skipping.", (Object)id);
                continue;
            }
            StringFormulaOutcome string_outcome = (StringFormulaOutcome)((Object)outcome);
            String result = string_outcome.calculate(formula);
            if (result.isEmpty()) continue;
            return result;
        }
        return "";
    }

    @Override
    public void save(CompoundTag tag, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            tag.m_128365_(this.getTagName(), (Tag)StringTag.m_129297_((String)string));
        }
    }

    @Override
    public String fromTag(CompoundTag tag) {
        return tag.m_128461_(this.getTagName());
    }
}

