/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.material.formula;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.material.MaterialProperties;
import dev.hyperlynx.reactive.alchemy.material.YieldEntry;
import dev.hyperlynx.reactive.alchemy.material.formula.DefaultStringFormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.FloatOneToValueFormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.FloatZeroToMaxFormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.FormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.IntegerZeroToMaxFormulaOutcome;
import dev.hyperlynx.reactive.alchemy.material.formula.PropertyFormulaRequirements;
import dev.hyperlynx.reactive.alchemy.material.formula.RangeStringFormulaOutcome;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.RegistryObject;

public class MaterialFormulaMaps {
    public static final Map<ResourceLocation, PropertyFormulaRequirements> PROPERTY_FORMULA_MAP = new HashMap<ResourceLocation, PropertyFormulaRequirements>();
    public static final Map<ResourceLocation, List<FormulaOutcome>> FORMULA_OUTCOME_MAP = new HashMap<ResourceLocation, List<FormulaOutcome>>();
    public static final Map<ResourceLocation, YieldEntry> BASE_YIELDS = new HashMap<ResourceLocation, YieldEntry>();

    public static void init() {
        new MapBuilder<PropertyFormulaRequirements>(PROPERTY_FORMULA_MAP).add(MaterialProperties.MAGMA_STEP, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.BLAZE_POWER.getId(), 500, 1000))), false).add(MaterialProperties.FIRE_SOURCE, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.BLAZE_POWER.getId(), 1, 200))), false).add(MaterialProperties.REDSTONE, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.MIND_POWER.getId(), 10, 25))), false).add(MaterialProperties.LIGHT, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.LIGHT_POWER.getId(), 200, 200))), false).add(MaterialProperties.FLAMMABILITY, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.VERDANT_POWER.getId(), 120, 240))), false).add(MaterialProperties.ENCHANT_POWER, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.SOUL_POWER.getId(), 50, 250), new PropertyFormulaRequirements.Part(Powers.MIND_POWER.getId(), 50, 50))), false).add(MaterialProperties.BLAST_RESISTANCE, new PropertyFormulaRequirements(List.of()), false).add(MaterialProperties.FRICTION, new PropertyFormulaRequirements(List.of()), false).add(MaterialProperties.BREAK_STRENGTH, new PropertyFormulaRequirements(List.of()), false).add(MaterialProperties.MODEL_NAME, new PropertyFormulaRequirements(List.of()), false).add(MaterialProperties.SELF_DEFENSE, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.VITAL_POWER.getId(), 1000, 1150))), false).add(MaterialProperties.WARPING, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.WARP_POWER.getId(), 2000, 2000))), false).add(MaterialProperties.REDSTONE_MELTING, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.ACID_POWER.getId(), 20, 50), new PropertyFormulaRequirements.Part(Powers.MIND_POWER.getId(), 10, 100))), false).add(MaterialProperties.INTANGIBLE, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.SOUL_POWER.getId(), 1700, 2300))), false).add(MaterialProperties.SEMITANGIBLE, new PropertyFormulaRequirements(List.of(new PropertyFormulaRequirements.Part(Powers.SOUL_POWER.getId(), 800, 1300), new PropertyFormulaRequirements.Part(Powers.WARP_POWER.getId(), 10, 20))), false);
        new MapBuilder<List<FormulaOutcome>>(FORMULA_OUTCOME_MAP).add(MaterialProperties.LIGHT, List.of(new IntegerZeroToMaxFormulaOutcome(Powers.LIGHT_POWER.getId(), 200, 1600, 15)), false).add(MaterialProperties.REDSTONE, List.of(new IntegerZeroToMaxFormulaOutcome(Powers.MIND_POWER.getId(), 10, 2000, 15)), false).add(MaterialProperties.FLAMMABILITY, List.of(new IntegerZeroToMaxFormulaOutcome(Powers.VERDANT_POWER.getId(), 120, 1000, 300)), false).add(MaterialProperties.ENCHANT_POWER, List.of(new FloatZeroToMaxFormulaOutcome(Powers.MIND_POWER.getId(), 50, 3000, 5.0f)), false).add(MaterialProperties.BLAST_RESISTANCE, List.of(new FloatOneToValueFormulaOutcome(Powers.VITAL_POWER.getId(), 250, 500, 100.0f), new FloatOneToValueFormulaOutcome(Powers.CURSE_POWER.getId(), 0, 20, 0.0f), new FloatOneToValueFormulaOutcome(Powers.BODY_POWER.getId(), 0, 1200, 10.0f), new FloatOneToValueFormulaOutcome(Powers.SOUL_POWER.getId(), 500, 550, 2.0f), new FloatOneToValueFormulaOutcome(Powers.WARP_POWER.getId(), 100, 550, 0.2f), new FloatOneToValueFormulaOutcome(Powers.LIGHT_POWER.getId(), 2500, 3200, 5.0f)), false).add(MaterialProperties.FRICTION, List.of(new FloatOneToValueFormulaOutcome(Powers.WARP_POWER.getId(), 50, 2000, 0.9f)), false).add(MaterialProperties.BREAK_STRENGTH, List.of(new FloatOneToValueFormulaOutcome(Powers.VITAL_POWER.getId(), 100, 110, 1.5f), new FloatOneToValueFormulaOutcome(Powers.CURSE_POWER.getId(), 0, 20, 0.01f), new FloatOneToValueFormulaOutcome(Powers.BODY_POWER.getId(), 0, 3200, 6.0f), new FloatOneToValueFormulaOutcome(Powers.VERDANT_POWER.getId(), 0, 3200, 2.5f), new FloatOneToValueFormulaOutcome(Powers.ACID_POWER.getId(), 200, 250, 0.5f), new FloatOneToValueFormulaOutcome(Powers.WARP_POWER.getId(), 100, 550, 0.25f), new FloatOneToValueFormulaOutcome(Powers.MIND_POWER.getId(), 777, 877, 1.05f), new FloatOneToValueFormulaOutcome(Powers.LIGHT_POWER.getId(), 2500, 3200, 5.0f)), false).add(MaterialProperties.MODEL_NAME, List.of(new RangeStringFormulaOutcome("cracked", Powers.CURSE_POWER.getId(), 10, Optional.empty()), new RangeStringFormulaOutcome("streaked", Powers.X_POWER.getId(), 20, Optional.empty()), new RangeStringFormulaOutcome("circles", Powers.Y_POWER.getId(), 20, Optional.empty()), new RangeStringFormulaOutcome("smooth", Powers.Z_POWER.getId(), 20, Optional.empty()), new RangeStringFormulaOutcome("cracked", Powers.BODY_POWER.getId(), 500, Optional.of(1200)), new RangeStringFormulaOutcome("streaked", Powers.BODY_POWER.getId(), 1200, Optional.empty()), new RangeStringFormulaOutcome("streaked", Powers.VITAL_POWER.getId(), 1000, Optional.empty()), new RangeStringFormulaOutcome("smooth", Powers.WARP_POWER.getId(), 500, Optional.of(1400)), new RangeStringFormulaOutcome("squares", Powers.WARP_POWER.getId(), 1400, Optional.of(1500)), new RangeStringFormulaOutcome("static", Powers.WARP_POWER.getId(), 2000, Optional.empty()), new RangeStringFormulaOutcome("circles", Powers.MIND_POWER.getId(), 1500, Optional.empty()), new RangeStringFormulaOutcome("streaked", Powers.VERDANT_POWER.getId(), 1000, Optional.empty()), new RangeStringFormulaOutcome("cracked", Powers.BLAZE_POWER.getId(), 20, Optional.empty()), new DefaultStringFormulaOutcome("default")), false).add(MaterialProperties.SELF_DEFENSE, List.of(new FloatOneToValueFormulaOutcome(Powers.VITAL_POWER.getId(), 1000, 1300, 3.0f)), false);
        new MapBuilder<YieldEntry>(BASE_YIELDS).add(Registration.SALT_BLOCK_ITEM, new YieldEntry(64, 1, "salt", Float.valueOf(1.0f)), false).add(Registration.ADEPT_SALT_BLOCK_ITEM, new YieldEntry(32, 4, "squares", Float.valueOf(1.33f)), false).add(Registration.CREATION_SALT_BLOCK_ITEM, new YieldEntry(16, 16, "static", Float.valueOf(2.0f)), false).add(Items.f_41870_.m_204114_().m_205785_().m_135782_(), new YieldEntry(64, 1, "wool", Float.valueOf(0.0f)), false);
    }

    private static class MapBuilder<T> {
        private final Map<ResourceLocation, T> map;

        MapBuilder(Map<ResourceLocation, T> map) {
            this.map = map;
        }

        MapBuilder<T> add(ResourceLocation id, T item, boolean overwrite) {
            if (overwrite) {
                this.map.put(id, item);
            } else {
                this.map.putIfAbsent(id, item);
            }
            return this;
        }

        MapBuilder<T> add(RegistryObject<?> object, T item, boolean overwrite) {
            return this.add(object.getId(), item, overwrite);
        }
    }
}

