/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.rxn.FreeEffectReaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.function.Consumer;

public class EffectReaction
extends FreeEffectReaction {
    int cost;

    public EffectReaction(String alias, Consumer<Reactor> effect, int numReagents) {
        super(alias, effect, numReagents);
        this.cost = WorldSpecificValue.get(alias + "cost", 10, 20);
    }

    public EffectReaction(String alias, Consumer<Reactor> function, Power required_power) {
        super(alias, function, required_power);
        this.cost = WorldSpecificValue.get(alias + "cost", 1, 20);
    }

    public EffectReaction(String alias, Consumer<Reactor> function, Power ... required_powers) {
        super(alias, function, required_powers);
        this.cost = WorldSpecificValue.get(alias + "cost", 1, 20);
    }

    @Override
    public void run(Reactor crucible) {
        super.run(crucible);
        for (Power p : this.reagents.keySet()) {
            crucible.expendPower(p, (int)((double)this.cost / (double)this.reagents.size()) + 1);
            crucible.setDirty();
        }
    }

    public Reaction setCost(int i) {
        this.cost = i;
        return this;
    }
}

