/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.rxn;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.rxn.Reactor;
import dev.hyperlynx.reactive.alchemy.special.SpecialCaseMan;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.blocks.NoduleBlock;
import dev.hyperlynx.reactive.blocks.ShulkerCrucibleBlock;
import dev.hyperlynx.reactive.client.particles.EnergyParticle;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.entities.ReactorEntity;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.util.BeamHelper;
import dev.hyperlynx.reactive.util.BlockMoveChecker;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ReactionEffects {
    public static void explosion(Reactor reactor) {
        BlockPos pos = reactor.blockPos();
        ParticleScribe.drawParticleZigZag(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123762_, pos, reactor.getAreaMemory().fetch(reactor.obtainLevel(), (Block)Registration.GOLD_SYMBOL.get()), 20, 7, 0.8f);
        if (reactor.getAreaMemory().exists(reactor.obtainLevel(), (Block)Registration.IRON_SYMBOL.get())) {
            ParticleScribe.drawParticleZigZag(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123762_, reactor.getAreaMemory().fetch(reactor.obtainLevel(), (Block)Registration.GOLD_SYMBOL.get()), reactor.getAreaMemory().fetch(reactor.obtainLevel(), (Block)Registration.IRON_SYMBOL.get()), 20, 7, 0.8f);
        } else {
            reactor.expendPower();
            if (reactor instanceof CrucibleBlockEntity) {
                CrucibleBlockEntity crucible = (CrucibleBlockEntity)reactor;
                SpecialCaseMan.checkEmptySpecialCases(crucible);
                reactor.obtainLevel().m_7731_(pos, (BlockState)reactor.obtainLevel().m_8055_(pos).m_61124_((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(false)), 2);
            }
            reactor.obtainLevel().m_254849_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1.0f, Level.ExplosionInteraction.NONE);
            if (reactor.getAreaMemory().exists(reactor.obtainLevel(), (Block)Registration.GOLD_SYMBOL.get())) {
                reactor.obtainLevel().m_7471_(reactor.getAreaMemory().fetch(reactor.obtainLevel(), (Block)Registration.GOLD_SYMBOL.get()), true);
            }
        }
    }

    public static void foaming(Reactor reactor) {
        BlockPos symbol_position = reactor.getAreaMemory().fetch(reactor.obtainLevel(), (Block)Registration.GOLD_SYMBOL.get());
        if (symbol_position == null) {
            return;
        }
        reactor.obtainLevel().m_7731_(symbol_position, ((Block)Registration.ACTIVE_GOLD_FOAM.get()).m_49966_(), 2);
        ParticleScribe.drawParticleZigZag(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123806_, (float)reactor.blockPos().m_123341_() + 0.5f, (float)reactor.blockPos().m_123342_() + 0.5625f, (float)reactor.blockPos().m_123343_() + 0.5f, (double)symbol_position.m_123341_() + 0.5, (double)symbol_position.m_123342_() + 0.5, (double)symbol_position.m_123343_() + 0.5, 12, 7, 0.4);
    }

    public static void smoke(Reactor reactor) {
        if ((double)reactor.obtainLevel().f_46441_.m_188501_() < 0.4) {
            AABB aoe = new AABB(reactor.blockPos());
            aoe = aoe.m_82400_(3.0);
            List nearby_ents = reactor.obtainLevel().m_45976_(LivingEntity.class, aoe);
            for (LivingEntity e : nearby_ents) {
                if (!CrystalIronItem.effectNotBlocked(e, 1)) continue;
                e.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 1));
                e.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 200, 1));
                e.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200, 1));
            }
        }
    }

    public static void salt(Reactor reactor) {
        if (reactor.getTotalPowerLevel() < WorldSpecificValue.get("salt_overflow_threshold", 1000, 1300)) {
            ItemEntity salt_drop = new ItemEntity(reactor.obtainLevel(), (double)reactor.blockPos().m_123341_() + 0.5, (double)reactor.blockPos().m_123342_() + 0.5, (double)reactor.blockPos().m_123343_() + 0.6, ((Item)Registration.SALT.get()).m_7968_());
            reactor.obtainLevel().m_7967_((Entity)salt_drop);
        } else {
            if (reactor instanceof CrucibleBlockEntity) {
                CrucibleBlockEntity crucible = (CrucibleBlockEntity)reactor;
                CrucibleBlockEntity.empty(reactor.obtainLevel(), reactor.blockPos(), reactor.blockState(), crucible);
                if (reactor.blockState().m_60734_() instanceof ShulkerCrucibleBlock) {
                    ItemEntity shell_drop = new ItemEntity(reactor.obtainLevel(), (double)reactor.blockPos().m_123341_() + 0.5, (double)reactor.blockPos().m_123342_() + 0.5, (double)reactor.blockPos().m_123343_() + 0.6, Items.f_42748_.m_7968_());
                    reactor.obtainLevel().m_7967_((Entity)shell_drop);
                }
                reactor.obtainLevel().m_7731_(reactor.blockPos(), ((Block)Registration.SALTY_CRUCIBLE.get()).m_49966_(), 2);
            } else if (reactor instanceof ReactorEntity) {
                ReactorEntity entity = (ReactorEntity)reactor;
                entity.obtainLevel().m_7731_(entity.blockPos(), ((Block)Registration.SALT_BLOCK.get()).m_49966_(), 2);
                entity.m_6074_();
            }
            reactor.obtainLevel().m_5594_(null, reactor.blockPos(), SoundEvents.f_11986_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void discharge(Reactor reactor) {
        Level level = reactor.obtainLevel();
        reactor.addElectricCharge(5);
        if (reactor.getElectricCharge() > 21) {
            BlockPos potential_rod = reactor.getAreaMemory().fetch(level, Blocks.f_152587_);
            if (potential_rod != null) {
                if (!reactor.obtainLevel().f_46443_) {
                    ((LightningRodBlock)Blocks.f_152587_).m_153760_(reactor.obtainLevel().m_8055_(potential_rod), level, potential_rod);
                    ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ParticleTypes.f_175830_, reactor.getPos().f_82479_, reactor.getPos().f_82480_, reactor.getPos().f_82481_, (double)potential_rod.m_123341_() + 0.5, (double)potential_rod.m_123342_() + 0.5, (double)potential_rod.m_123343_() + 0.5, 8, 10, 0.6);
                    reactor.obtainLevel().m_5594_(null, potential_rod, (SoundEvent)Registration.ZAP_SOUND.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            } else {
                AABB aoe = new AABB(reactor.blockPos());
                aoe = aoe.m_82400_((double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue());
                List nearby_ents = reactor.obtainLevel().m_45976_(LivingEntity.class, aoe);
                LivingEntity victim = null;
                for (LivingEntity e : nearby_ents) {
                    if (victim != null && !(e.m_20238_(Vec3.m_82512_((Vec3i)reactor.blockPos())) < victim.m_20238_(Vec3.m_82512_((Vec3i)reactor.blockPos()))) || !BeamHelper.hasLineOfSight(level, Vec3.m_82512_((Vec3i)reactor.blockPos()), e.m_20299_(0.0f), ClipContext.Fluid.NONE, ClipContext.Block.COLLIDER, reactor.blockState().m_60734_())) continue;
                    victim = e;
                }
                if (victim == null) {
                    return;
                }
                if (!level.f_46443_) {
                    if (CrystalIronItem.effectNotBlocked(victim, 2)) {
                        victim.m_6469_(reactor.obtainLevel().m_269111_().m_269425_(), 5.0f);
                    }
                    ParticleScribe.drawParticleZigZag(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_175830_, reactor.getPos().f_82479_, reactor.getPos().f_82480_, reactor.getPos().f_82481_, victim.m_20185_(), (double)(victim.m_20192_() / 2.0f) + victim.m_20186_(), victim.m_20189_(), 8, 10, 0.3);
                    reactor.obtainLevel().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), (SoundEvent)Registration.ZAP_SOUND.get(), SoundSource.BLOCKS, 0.5f, 0.98f + reactor.obtainLevel().f_46441_.m_188501_() * 0.05f);
                }
            }
            reactor.setElectricCharge(0);
        }
        reactor.setDirty();
    }

    public static void levitation(Reactor reactor) {
        AABB aoe = new AABB(reactor.blockPos());
        aoe = aoe.m_82400_(12.0);
        List nearby_ents = reactor.obtainLevel().m_45976_(LivingEntity.class, aoe);
        for (LivingEntity victim : nearby_ents) {
            if (CrystalIronItem.effectNotBlocked(victim, 1)) {
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 200, 1));
                if (victim instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)victim;
                    CriteriaTriggers.BE_LEVITATED_TRIGGER.trigger(player);
                }
            }
            ParticleScribe.drawParticleZigZag(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123810_, reactor.getPos().f_82479_, reactor.getPos().f_82480_, reactor.getPos().f_82481_, victim.m_20185_(), victim.m_20188_() - 0.2, victim.m_20189_(), 8, 7, 0.74);
            float pitch = 0.8f + reactor.obtainLevel().f_46441_.m_188501_() * 0.1f;
            reactor.obtainLevel().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), (SoundEvent)SoundEvents.f_12211_.m_203334_(), SoundSource.BLOCKS, 0.3f, pitch);
            reactor.obtainLevel().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), (SoundEvent)SoundEvents.f_12211_.m_203334_(), SoundSource.BLOCKS, 0.3f, pitch / 2.0f);
        }
    }

    public static void slowfall(Reactor reactor) {
        AABB aoe = new AABB(reactor.blockPos());
        aoe = aoe.m_82400_(12.0);
        List nearby_ents = reactor.obtainLevel().m_45976_(LivingEntity.class, aoe);
        for (LivingEntity victim : nearby_ents) {
            if (CrystalIronItem.effectNotBlocked(victim, 1)) {
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 1));
                if (victim instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)victim;
                    CriteriaTriggers.BE_SLOWFALLED_TRIGGER.trigger(player);
                }
            }
            ParticleScribe.drawExactParticleRing(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123810_, reactor.getPos(), 0.0, 0.6, 1);
            reactor.obtainLevel().m_6263_(null, victim.m_20185_(), victim.m_20186_(), victim.m_20189_(), SoundEvents.f_11822_, SoundSource.BLOCKS, 0.1f, 1.2f);
        }
        if (reactor.getLinkedCrystal() != null && reactor.getPowerLevel((Power)Powers.LIGHT_POWER.get()) > WorldSpecificValue.get("levitationcost", 10, 30)) {
            ReactionEffects.craftSecretScale(reactor);
        }
    }

    private static void craftSecretScale(Reactor reactor) {
        for (Entity entity : CrucibleBlock.getEntitesInside(reactor.blockPos(), reactor.obtainLevel())) {
            ItemEntity item_entity;
            if (!(entity instanceof ItemEntity) || !(item_entity = (ItemEntity)entity).m_32055_().m_150930_((Item)Registration.PHANTOM_RESIDUE.get())) continue;
            ParticleScribe.drawParticleZigZag(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123810_, reactor.blockPos().m_123341_(), reactor.blockPos().m_123342_(), reactor.blockPos().m_123343_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 25, 10, 0.9);
            reactor.obtainLevel().m_5594_(null, reactor.blockPos(), SoundEvents.f_12376_, SoundSource.BLOCKS, 0.8f, 0.8f);
            int count = item_entity.m_32055_().m_41613_();
            item_entity.m_6074_();
            ItemStack drop_stack = ((Item)Registration.SECRET_SCALE.get()).m_7968_();
            drop_stack.m_41764_(count);
            ItemEntity secret_scale = new ItemEntity(reactor.obtainLevel(), (double)reactor.blockPos().m_123341_() + 0.5, (double)reactor.blockPos().m_123342_() + 0.6, (double)reactor.blockPos().m_123343_() + 0.5, drop_stack);
            secret_scale.m_32010_(20);
            reactor.obtainLevel().m_7967_((Entity)secret_scale);
            reactor.obtainLevel().m_7731_(reactor.blockPos(), (BlockState)reactor.blockState().m_61124_((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public static void growth(Reactor reactor) {
        Random random = new Random();
        BlockPos target = reactor.blockPos().m_7918_(random.nextInt(-32, 32), random.nextInt(-1, 0), random.nextInt(-32, 32));
        if (Objects.requireNonNull(reactor.obtainLevel()).m_8055_(target).m_60734_() instanceof BonemealableBlock) {
            ((BonemealableBlock)reactor.obtainLevel().m_8055_(target).m_60734_()).m_214148_((ServerLevel)reactor.obtainLevel(), reactor.obtainLevel().f_46441_, target, reactor.obtainLevel().m_8055_(target));
        }
    }

    public static void flamethrower(Reactor reactor) {
        if (reactor.obtainLevel() == null) {
            return;
        }
        AABB blast_zone = new AABB(reactor.blockPos());
        blast_zone = blast_zone.m_82377_(2.0, 5.0, 2.0);
        List nearby_ents = reactor.obtainLevel().m_45976_(LivingEntity.class, blast_zone);
        for (LivingEntity e : nearby_ents) {
            if (!BeamHelper.hasLineOfSight(reactor.obtainLevel(), reactor.blockPos().m_252807_(), e.m_20299_(0.0f), ClipContext.Fluid.NONE, ClipContext.Block.COLLIDER, reactor.blockState().m_60734_())) continue;
            e.m_7311_(140);
        }
    }

    public static void sunlight(Reactor reactor) {
        int range = 12;
        AABB aoe = new AABB(reactor.blockPos());
        aoe = aoe.m_82400_((double)range);
        List nearby_monsters = reactor.obtainLevel().m_45976_(Monster.class, aoe);
        for (Monster m : nearby_monsters) {
            if (!m.m_21222_() || !(m.m_20318_(0.0f).m_82554_(reactor.blockPos().m_252807_()) < (double)range)) continue;
            m.m_6469_(reactor.obtainLevel().m_269111_().m_269387_(), 3.0f);
            m.m_7311_(100);
        }
        ParticleScribe.drawExactParticleRing(reactor.obtainLevel(), (ParticleOptions)ParticleTypes.f_123810_, reactor.getPos().m_82520_(0.0, 0.1, 0.0), 0.0, 12.0, 20);
    }

    public static void blockfall(Reactor reactor) {
        Level level = reactor.obtainLevel();
        RandomSource random = level.f_46441_;
        BlockPos symbol_pos = reactor.getAreaMemory().fetch(level, (Block)Registration.GOLD_SYMBOL.get());
        if (symbol_pos == null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            BlockState target_state;
            BlockPos target = symbol_pos.m_7918_(random.m_216339_(-4, 4), random.m_216339_(0, 4), random.m_216339_(-4, 4));
            if (target == reactor.blockPos() || target == symbol_pos || (target_state = level.m_8055_(target)).m_60795_() || !BlockMoveChecker.canMakeBlockFall(reactor.obtainLevel(), target, target_state)) continue;
            FallingBlockEntity.m_201971_((Level)level, (BlockPos)target, (BlockState)target_state);
            ParticleScribe.drawParticleZigZag(level, (ParticleOptions)ParticleTypes.f_123810_, reactor.blockPos(), target, 8, 32, 0.7f);
            ItemEntity drop = new ItemEntity(level, (double)reactor.blockPos().m_123341_() + 0.5, (double)reactor.blockPos().m_123342_() + 0.6, (double)reactor.blockPos().m_123343_() + 0.5, ((Item)Registration.MOTION_SALT.get()).m_7968_());
            level.m_7967_((Entity)drop);
        }
    }

    public static void immobilize(Reactor reactor) {
        Level level = reactor.obtainLevel();
        if (level == null) {
            return;
        }
        AABB aoe = new AABB(reactor.blockPos());
        aoe = aoe.m_82400_(2.0);
        List nearby = level.m_45976_(LivingEntity.class, aoe);
        for (LivingEntity living : nearby) {
            MobEffectInstance stop;
            Player player;
            ParticleScribe.drawParticleReactionSurface(level, (ParticleOptions)ParticleTypes.f_123789_, reactor);
            if (!CrystalIronItem.effectNotBlocked(living, 1)) continue;
            if (living instanceof Player && (player = (Player)living).m_6144_()) {
                stop = new MobEffectInstance(MobEffects.f_19597_, 50);
                player.m_7292_(stop);
                continue;
            }
            stop = new MobEffectInstance((MobEffect)Registration.IMMOBILE.get(), 50, 0, true, false, true);
            living.m_7292_(stop);
        }
    }

    public static void creation(Reactor reactor) {
        Level level = Objects.requireNonNull(reactor.obtainLevel());
        if ((double)level.f_46441_.m_188501_() < 0.35) {
            for (BlockPos creation_point : ReactionEffects.getCreationPoints(reactor.blockPos())) {
                if (!level.m_8055_(creation_point).m_60795_() || !level.m_46749_(creation_point)) continue;
                if ((double)level.f_46441_.m_188501_() < 0.34) {
                    level.m_7731_(creation_point, ((Block)Registration.CREATION_SALT_BLOCK.get()).m_49966_(), 2);
                    level.m_46672_(creation_point, (Block)Registration.CREATION_SALT_BLOCK.get());
                } else {
                    level.m_7731_(creation_point, ((Block)Registration.UNFORMED_MATTER.get()).m_49966_(), 2);
                    level.m_46672_(creation_point, (Block)Registration.UNFORMED_MATTER.get());
                }
                ParticleScribe.drawParticleZigZag(level, (ParticleOptions)Registration.STARDUST_PARTICLE, reactor.blockPos(), creation_point, 10, 5, 0.5);
                break;
            }
        }
    }

    public static Set<BlockPos> getCreationPoints(BlockPos origin) {
        HashSet<BlockPos> points = new HashSet<BlockPos>();
        Random wsv_source = WorldSpecificValue.getSource("creation_points");
        while (points.size() < 3) {
            points.add(origin.m_7918_(wsv_source.nextInt(0, 3) * 2 - 3, wsv_source.nextInt(0, 2) * 2 + 2, wsv_source.nextInt(0, 3) * 2 - 3));
        }
        return points;
    }

    public static void cryo(Reactor reactor) {
        Level level = reactor.obtainLevel();
        if (level == null) {
            return;
        }
        AABB aoe = new AABB(reactor.blockPos());
        aoe = aoe.m_82400_(5.0);
        List nearby = level.m_45976_(LivingEntity.class, aoe);
        for (LivingEntity living : nearby) {
            if (!CrystalIronItem.effectNotBlocked(living, 1)) continue;
            living.m_146917_(200);
        }
        BlockPos.m_121921_((AABB)aoe).forEach(pos -> {
            if (level.m_8055_(pos).m_60713_(Blocks.f_50449_)) {
                level.m_7731_(pos, Blocks.f_50449_.m_49966_(), 2);
            }
            if (level.m_8055_(pos).m_60713_(Blocks.f_49990_) && level.m_8055_(pos.m_7494_()).m_60795_()) {
                level.m_7731_(pos, Blocks.f_50449_.m_49966_(), 2);
                reactor.addPower((Power)Powers.BLAZE_POWER.get(), 3);
            }
        });
    }

    public static void noduleGrowth(Reactor reactor) {
        Level level = reactor.obtainLevel();
        if (level == null) {
            return;
        }
        int range = 4;
        BlockPos pos = reactor.blockPos().m_7918_(level.f_46441_.m_216339_(-range, range + 1), level.f_46441_.m_216339_(-1, range), level.f_46441_.m_216339_(-range, range + 1));
        if (!level.m_8055_(pos).m_60795_()) {
            if (level.m_8055_(pos).m_60713_((Block)Registration.UNGROWN_NODULE.get())) {
                BlockState old_state = level.m_8055_(pos);
                Direction direction = (Direction)old_state.m_61143_((Property)NoduleBlock.f_52588_);
                level.m_7731_(pos, (BlockState)((NoduleBlock)((Object)Registration.NODULE.get())).m_49966_().m_61124_((Property)NoduleBlock.f_52588_, (Comparable)direction), 2);
                ReactionEffects.runNodulePlaceEffects(pos, direction, level, reactor);
                level.m_5594_(null, pos, SoundEvents.f_11871_, SoundSource.BLOCKS, 0.2f, 0.7f + level.f_46441_.m_188501_() * 0.1f);
            }
            return;
        }
        for (Direction direction : Direction.m_235667_((RandomSource)level.f_46441_)) {
            BlockPos side_pos = pos.m_121955_(new Vec3i(direction.m_122429_(), direction.m_122430_(), direction.m_122431_()));
            if (!level.m_8055_(side_pos).m_60838_((BlockGetter)level, side_pos)) continue;
            level.m_7731_(pos, (BlockState)((NoduleBlock)((Object)Registration.UNGROWN_NODULE.get())).m_49966_().m_61124_((Property)NoduleBlock.f_52588_, (Comparable)direction), 2);
            ReactionEffects.runNodulePlaceEffects(pos, direction, level, reactor);
            return;
        }
    }

    private static void runNodulePlaceEffects(BlockPos pos, Direction direction, Level level, Reactor reactor) {
        reactor.expendPower((Power)Powers.WARP_POWER.get(), 4);
        level.m_5594_(null, pos, SoundEvents.f_144235_, SoundSource.BLOCKS, 1.0f, 1.2f);
        Vec3 beam_target = pos.m_252807_().m_82549_(new Vec3(direction.m_253071_()).m_82490_(0.3));
        ParticleScribe.drawParticleLine(level, (ParticleOptions)new EnergyParticle.Options(0.2f, ((Power)Powers.Z_POWER.get()).getColor(), beam_target, false), reactor.blockPos().m_252807_(), beam_target, 50, (double)0.05f);
    }

    public static void omenSettling(Reactor reactor) {
        if (reactor.obtainLevel().f_46441_.m_188501_() < 0.1f) {
            reactor.addPower((Power)Powers.CURSE_POWER.get(), 1);
        }
        reactor.addPower((Power)Powers.SOUL_POWER.get(), 2);
    }
}

