/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.alchemy.special;

import dev.hyperlynx.reactive.ConfigMan;
import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.advancements.CriteriaTriggers;
import dev.hyperlynx.reactive.advancements.FlagCriterion;
import dev.hyperlynx.reactive.alchemy.Power;
import dev.hyperlynx.reactive.alchemy.Powers;
import dev.hyperlynx.reactive.alchemy.WorldSpecificValues;
import dev.hyperlynx.reactive.alchemy.material.MaterialMan;
import dev.hyperlynx.reactive.alchemy.material.YieldEntry;
import dev.hyperlynx.reactive.alchemy.material.formula.Formula;
import dev.hyperlynx.reactive.alchemy.material.formula.MaterialFormulaMaps;
import dev.hyperlynx.reactive.alchemy.rxn.Reaction;
import dev.hyperlynx.reactive.alchemy.rxn.ReactionStatusEntry;
import dev.hyperlynx.reactive.alchemy.special.BottleSpecialCase;
import dev.hyperlynx.reactive.alchemy.special.DissolveEvent;
import dev.hyperlynx.reactive.alchemy.special.DissolveSpecialCase;
import dev.hyperlynx.reactive.alchemy.special.EmptyEvent;
import dev.hyperlynx.reactive.alchemy.special.EmptySpecialCase;
import dev.hyperlynx.reactive.be.CrucibleBlockEntity;
import dev.hyperlynx.reactive.blocks.CrucibleBlock;
import dev.hyperlynx.reactive.blocks.DisplacedBlock;
import dev.hyperlynx.reactive.blocks.IncompleteStaffBlock;
import dev.hyperlynx.reactive.client.particles.ParticleScribe;
import dev.hyperlynx.reactive.entities.ReactorEntity;
import dev.hyperlynx.reactive.items.CrystalIronItem;
import dev.hyperlynx.reactive.items.LitmusPaperItem;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.items.WarpBottleItem;
import dev.hyperlynx.reactive.util.HyperPortalShape;
import dev.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.Event;

public class SpecialCaseMan {
    public static List<DissolveSpecialCase> DISSOLVE_SPECIAL_CASES = new ArrayList<DissolveSpecialCase>();
    public static List<EmptySpecialCase> EMPTY_SPECIAL_CASES = new ArrayList<EmptySpecialCase>();
    public static List<BottleSpecialCase> BOTTLE_SPECIAL_CASES = new ArrayList<BottleSpecialCase>();
    private static final int MATERIAL_CRAFT_MIN_POWER = 800;

    public static void checkDissolveSpecialCases(CrucibleBlockEntity c, ItemEntity e) {
        MinecraftForge.EVENT_BUS.post((Event)new DissolveEvent(e, c));
        for (DissolveSpecialCase dissolve_case : DISSOLVE_SPECIAL_CASES) {
            if (dissolve_case.attempt(c, e)) break;
        }
    }

    public static void checkEmptySpecialCases(CrucibleBlockEntity c) {
        MinecraftForge.EVENT_BUS.post((Event)new EmptyEvent(c));
        if (c.obtainLevel() == null) {
            return;
        }
        for (EmptySpecialCase empty_case : EMPTY_SPECIAL_CASES) {
            empty_case.attempt(c);
        }
    }

    public static ItemStack checkBottleSpecialCases(CrucibleBlockEntity c, ItemStack b) {
        ItemStack bottle = b.m_41777_();
        for (BottleSpecialCase bottle_case : BOTTLE_SPECIAL_CASES) {
            bottle = bottle_case.attempt(c, bottle);
        }
        return bottle;
    }

    public static void bootstrap() {
        SpecialCaseMan.register_dissolve_cases();
        SpecialCaseMan.register_empty_cases();
        SpecialCaseMan.register_bottle_cases();
    }

    public static void register_dissolve_cases() {
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_150930_((Item)Registration.LITMUS_PAPER.get())) {
                LitmusPaperItem.takeMeasurement(e.m_32055_(), c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_204117_(Tags.Items.ENDER_PEARLS)) {
                SpecialCaseMan.enderPearlDissolve(Objects.requireNonNull(c.obtainLevel()), c.m_58899_(), e, c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_204117_(Tags.Items.GUNPOWDER) && c.getPowerLevel((Power)Powers.BLAZE_POWER.get()) > 10) {
                SpecialCaseMan.explodeGunpowderDueToBlaze(Objects.requireNonNull(c.obtainLevel()), c.m_58899_(), e);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_150930_(Items.f_42047_)) {
                SpecialCaseMan.pumpkinMagic(Objects.requireNonNull(c.obtainLevel()), e, c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_150930_(Items.f_42614_)) {
                SpecialCaseMan.waterWriting(c, e);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_204117_(Tags.Items.INGOTS_COPPER) && c.getPowerLevel((Power)Powers.ACID_POWER.get()) > 10) {
                SpecialCaseMan.copperCharging(c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_150930_(Items.f_42545_) && c.getPowerLevel((Power)Powers.CURSE_POWER.get()) < 10) {
                SpecialCaseMan.enderEyeFlyAway(c, e);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_150930_((Item)Registration.PHANTOM_RESIDUE.get()) && c.getPowerLevel((Power)Powers.VERDANT_POWER.get()) > 700) {
                SpecialCaseMan.residualSlime(c, e);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_150930_(Items.f_220194_)) {
                SpecialCaseMan.sculkMagic(c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if ((e.m_32055_().m_150930_((Item)Registration.MOTION_SALT_BLOCK_ITEM.get()) || e.m_32055_().m_150930_((Item)Registration.FRAMED_MOTION_SALT_BLOCK_ITEM.get())) && c.electricCharge > 0) {
                SpecialCaseMan.displaceNearby(c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_150930_((Item)Registration.INERT_CRYSTAL.get())) {
                SpecialCaseMan.preventReactions(c);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (e.m_32055_().m_150930_((Item)Registration.GOLD_THREAD.get())) {
                SpecialCaseMan.expelReaction(c, e);
                return true;
            }
            return false;
        });
        DISSOLVE_SPECIAL_CASES.add((c, e) -> {
            if (MaterialFormulaMaps.BASE_YIELDS.containsKey(e.m_32055_().m_41720_().m_204114_().m_205785_().m_135782_())) {
                SpecialCaseMan.saltMaterialCraft(c, e);
                return true;
            }
            return false;
        });
    }

    public static void register_empty_cases() {
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.SOUL_POWER.get()) > WorldSpecificValue.get("soul_escape_threshold", 300, 600)) {
                SpecialCaseMan.soulEscape(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.CURSE_POWER.get()) > 665) {
                SpecialCaseMan.curseEscape(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.BLAZE_POWER.get()) > WorldSpecificValue.get("blaze_escape_threshold", 20, 100)) {
                SpecialCaseMan.blazeEscape(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.VERDANT_POWER.get()) > WorldSpecificValue.get("verdant_escape_threshold", 1300, 1500)) {
                SpecialCaseMan.verdantEscape(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.getPowerLevel((Power)Powers.LIGHT_POWER.get()) > WorldSpecificValue.get("light_escape_threshold", 800, 1100)) {
                SpecialCaseMan.lightEscape(c);
            }
        });
        EMPTY_SPECIAL_CASES.add(c -> {
            if (c.areaMemory.exists(c.obtainLevel(), (Block)Registration.INCOMPLETE_STAFF.get())) {
                IncompleteStaffBlock.staffCraftStep(c, c.areaMemory.fetch(c.obtainLevel(), (Block)Registration.INCOMPLETE_STAFF.get()));
            }
        });
    }

    public static void register_bottle_cases() {
        BOTTLE_SPECIAL_CASES.add((c, bottle) -> {
            if (c.enderRiftStrength > 0 && bottle.m_150930_((Item)Registration.WARP_BOTTLE.get())) {
                return WarpBottleItem.makeRiftBottle(c, bottle);
            }
            return bottle;
        });
    }

    private static void copperCharging(CrucibleBlockEntity c) {
        if (c.electricCharge < 20) {
            c.electricCharge += 2;
        }
    }

    private static void enderEyeFlyAway(CrucibleBlockEntity c, ItemEntity e) {
        ServerLevel serverlevel = (ServerLevel)c.obtainLevel();
        BlockPos blockpos = serverlevel.m_215011_(StructureTags.f_215882_, c.m_58899_(), 100, false);
        if (blockpos != null) {
            EyeOfEnder eyeofender = new EyeOfEnder(c.obtainLevel(), (double)c.m_58899_().m_123341_(), (double)c.m_58899_().m_123342_(), (double)c.m_58899_().m_123343_());
            eyeofender.m_36972_(e.m_32055_());
            eyeofender.m_36967_(blockpos);
            c.obtainLevel().m_7967_((Entity)eyeofender);
            c.obtainLevel().m_6263_(null, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.5, (double)c.m_58899_().m_123343_() + 0.5, SoundEvents.f_11898_, SoundSource.NEUTRAL, 0.5f, 0.4f / (c.obtainLevel().m_213780_().m_188501_() * 0.4f + 0.8f));
            e.m_32055_().m_41774_(1);
            if (e.m_32055_().m_41613_() < 1) {
                e.m_6074_();
            }
        }
    }

    private static void pumpkinMagic(Level level, ItemEntity e, CrucibleBlockEntity c) {
        if (level.f_46443_ || c.areaMemory.exists(level, (Block)Registration.IRON_SYMBOL.get())) {
            return;
        }
        BlockPos blazeRodPos = c.areaMemory.fetch(level, (Block)Registration.BLAZE_ROD.get());
        if (blazeRodPos != null && c.getPowerLevel((Power)Powers.BLAZE_POWER.get()) > 0) {
            SpecialCaseMan.conjureBlaze(level, e, c, blazeRodPos);
            return;
        }
        if (c.getPowerLevel((Power)Powers.SOUL_POWER.get()) == 0) {
            return;
        }
        int cause = WorldSpecificValues.GOLEM_CAUSE.get();
        BlockPos candlePos = c.areaMemory.fetch(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), (TagKey<Block>)BlockTags.f_144265_);
        if (candlePos != null && ((Boolean)level.m_8055_(candlePos).m_61143_((Property)CandleBlock.f_152791_)).booleanValue()) {
            SpecialCaseMan.conjureSpirit(level, e, c, cause, candlePos);
        }
    }

    private static void sculkMagic(CrucibleBlockEntity c) {
        if (!(c.obtainLevel() instanceof ServerLevel)) {
            return;
        }
        int spread = WorldSpecificValue.get("sculk_spread_amount", 12, 20);
        if (c.getPowerLevel((Power)Powers.SOUL_POWER.get()) > 800) {
            c.sculkSpreader.m_222266_(c.m_58899_().m_122012_(), spread);
            c.sculkSpreader.m_222266_(c.m_58899_().m_122019_(), spread);
            c.sculkSpreader.m_222266_(c.m_58899_().m_122029_(), spread);
            c.sculkSpreader.m_222266_(c.m_58899_().m_122024_(), spread);
            c.expendPower((Power)Powers.SOUL_POWER.get(), 500);
        } else if (c.getPowerLevel((Power)Powers.VITAL_POWER.get()) > 100) {
            c.expendPower((Power)Powers.VITAL_POWER.get(), 100);
            c.addPower((Power)Powers.SOUL_POWER.get(), WorldSpecificValue.get("sculk_soul_return", 60, 100));
        }
    }

    private static void conjureBlaze(Level level, ItemEntity e, CrucibleBlockEntity c, BlockPos blazeRodPos) {
        c.addPower((Power)Powers.BLAZE_POWER.get(), WorldSpecificValue.get("blaze_conjure_yield", 200, 400));
        EntityType.f_20551_.m_262455_((ServerLevel)level, (CompoundTag)null, null, blazeRodPos, MobSpawnType.MOB_SUMMONED, true, true);
        e.m_6074_();
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.f_123744_, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.5125, (double)c.m_58899_().m_123343_() + 0.5, (double)blazeRodPos.m_123341_() + 0.5, (double)blazeRodPos.m_123342_() + 0.38, (double)blazeRodPos.m_123343_() + 0.5, 20, 0.01);
        for (int i = 0; i < 10; ++i) {
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)blazeRodPos.m_123341_() + 0.5, (double)blazeRodPos.m_123342_() + 0.38, (double)blazeRodPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        level.m_5594_(null, blazeRodPos, SoundEvents.f_11705_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void conjureSpirit(Level level, ItemEntity e, CrucibleBlockEntity c, int cause, BlockPos candlePos) {
        if (cause == 1) {
            if ((double)level.f_46441_.m_188501_() > 0.07 && c.getPowerLevel((Power)Powers.CURSE_POWER.get()) <= 20) {
                EntityType.f_217014_.m_262455_((ServerLevel)level, (CompoundTag)null, null, candlePos, MobSpawnType.MOB_SUMMONED, true, true);
                var6_5 = e.m_19749_();
                if (var6_5 instanceof ServerPlayer) {
                    player = (ServerPlayer)var6_5;
                    CriteriaTriggers.SEE_ALLAY_SUMMON_TRIGGER.trigger(player);
                }
            } else {
                EntityType.f_20491_.m_262455_((ServerLevel)level, (CompoundTag)null, null, candlePos, MobSpawnType.MOB_SUMMONED, true, true);
            }
        } else if (cause == 2) {
            if ((double)level.f_46441_.m_188501_() > 0.07 && c.getPowerLevel((Power)Powers.MIND_POWER.get()) <= 20) {
                EntityType.f_20491_.m_262455_((ServerLevel)level, (CompoundTag)null, null, candlePos, MobSpawnType.MOB_SUMMONED, true, true);
            } else {
                EntityType.f_217014_.m_262455_((ServerLevel)level, (CompoundTag)null, null, candlePos, MobSpawnType.MOB_SUMMONED, true, true);
                var6_5 = e.m_19749_();
                if (var6_5 instanceof ServerPlayer) {
                    player = (ServerPlayer)var6_5;
                    CriteriaTriggers.SEE_ALLAY_SUMMON_TRIGGER.trigger(player);
                }
            }
        }
        e.m_6074_();
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.f_123808_, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.5125, (double)c.m_58899_().m_123343_() + 0.5, (double)candlePos.m_123341_() + 0.5, (double)candlePos.m_123342_() + 0.38, (double)candlePos.m_123343_() + 0.5, 20, 0.01);
        for (int i = 0; i < 10; ++i) {
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)candlePos.m_123341_() + 0.5, (double)candlePos.m_123342_() + 0.38, (double)candlePos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        level.m_5594_(null, candlePos, SoundEvents.f_12404_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void enderPearlDissolve(Level l, BlockPos p, ItemEntity e, CrucibleBlockEntity c) {
        float chance = (float)c.getPowerLevel((Power)Powers.WARP_POWER.get()) / 1600.0f;
        if (l.f_46441_.m_188501_() > chance) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            ((ServerLevel)l).m_8767_((ParticleOptions)ParticleTypes.f_123760_, e.m_20185_(), e.m_20186_() + l.f_46441_.m_188500_() * 2.0, e.m_20189_(), 1, l.f_46441_.m_188583_(), 0.0, l.f_46441_.m_188583_(), 0.0);
        }
        boolean foundTarget = false;
        Entity thrower = e.m_19749_();
        if (thrower != null) {
            Player player = l.m_46003_(thrower.m_20148_());
            if (!l.f_46443_) {
                CriteriaTriggers.ENDER_PEARL_DISSOLVE_TRIGGER.trigger((ServerPlayer)player);
            }
            if (player != null && e.m_9236_().m_46472_().equals((Object)player.m_9236_().m_46472_())) {
                player.m_6021_((double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.85, (double)p.m_123343_() + 0.5);
                foundTarget = true;
            }
        }
        if (!foundTarget) {
            FlagCriterion.triggerForNearbyPlayers((ServerLevel)l, CriteriaTriggers.MAKE_RIFT_TRIGGER, p, 20);
            c.enderRiftStrength = 2000;
        }
        e.m_6074_();
    }

    public static boolean tryTeleportNearbyEntity(BlockPos pos, Level level, BlockPos destination, boolean can_teleport_players) {
        AABB aoe = new AABB(pos);
        aoe = aoe.m_82400_((double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue());
        List nearby_ents = Objects.requireNonNull(level).m_45976_(LivingEntity.class, aoe);
        ArrayList<LivingEntity> to_be_excluded = new ArrayList<LivingEntity>();
        for (LivingEntity e : nearby_ents) {
            if (((List)ConfigMan.COMMON.doNotTeleport.get()).contains(e.m_20078_())) {
                to_be_excluded.add(e);
                continue;
            }
            if (e instanceof Player && !can_teleport_players) {
                to_be_excluded.add(e);
                continue;
            }
            if (CrystalIronItem.effectNotBlocked(e, (double)level.f_46441_.m_188501_() < 0.02 ? 1 : 0)) continue;
            to_be_excluded.add(e);
        }
        nearby_ents.removeAll(to_be_excluded);
        if (nearby_ents.isEmpty()) {
            return false;
        }
        LivingEntity victim = (LivingEntity)nearby_ents.get(0);
        for (LivingEntity e : nearby_ents) {
            if (!(e.m_20238_(Vec3.m_82512_((Vec3i)pos)) < victim.m_20238_(Vec3.m_82512_((Vec3i)pos)))) continue;
            victim = e;
        }
        victim.m_6021_((double)destination.m_123341_() + 0.5, (double)destination.m_123342_() + 0.85, (double)destination.m_123343_() + 0.5);
        return true;
    }

    private static void explodeGunpowderDueToBlaze(Level l, BlockPos p, ItemEntity e) {
        l.m_254849_((Entity)e, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, 1.0f, Level.ExplosionInteraction.NONE);
        e.m_6074_();
    }

    private static void waterWriting(CrucibleBlockEntity c, ItemEntity e) {
        int low = WorldSpecificValue.get("water_write_low_threshold", 200, 400);
        int high = WorldSpecificValue.get("water_write_high_threshold", 500, 800);
        if (c.getPowerLevel((Power)Powers.MIND_POWER.get()) < low) {
            boolean harvested = SpecialCaseMan.lowWaterWriting(c, e, low);
            if (harvested) {
                e.m_9236_().m_5594_(null, c.m_58899_(), SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, 1.0f);
                e.m_9236_().m_5594_(null, c.m_58899_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 0.6f, 0.6f);
            }
        } else if (c.getPowerLevel((Power)Powers.MIND_POWER.get()) > high) {
            SpecialCaseMan.highWaterWriting(c, e, high);
            e.m_9236_().m_5594_(null, c.m_58899_(), SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, 1.0f);
            e.m_9236_().m_5594_(null, c.m_58899_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 0.7f, 0.7f);
        }
    }

    private static void highWaterWriting(CrucibleBlockEntity c, ItemEntity e, int threshold) {
        ListTag pages;
        String CHAR_LIST = "abcdefhijklmnopqstuvwxyz, -;6'";
        CompoundTag book_tag = e.m_32055_().m_41783_();
        if (book_tag == null) {
            e.m_32055_().m_41700_("pages", (Tag)new ListTag());
            book_tag = e.m_32055_().m_41783_();
        }
        if ((pages = book_tag.m_128437_("pages", 8)).isEmpty() || e.m_9236_().f_46441_.m_188501_() < 0.5f && pages.size() < 40) {
            pages.add((Object)StringTag.m_129297_((String)""));
        }
        for (int page_index = 0; page_index < pages.size() && c.getPowerLevel((Power)Powers.MIND_POWER.get()) >= threshold; ++page_index) {
            ArrayList<String> words = new ArrayList<String>(List.of(pages.get(page_index).m_7916_().split("\\s+")));
            if (words.isEmpty() || e.m_9236_().f_46441_.m_188501_() < 0.1f) {
                if (e.m_19749_() != null && page_index == WorldSpecificValue.get("player_name_index", 0, 10)) {
                    words.add(e.m_19749_().m_7755_().getString());
                }
                if (page_index == WorldSpecificValue.get("devoid_prayer_index", 10, 40)) {
                    words.addAll(List.of(Component.m_237115_((String)"text.reactive.devoid").getString().split("\\s+")));
                } else {
                    words.add(WorldSpecificValue.getFromCollection("devoid_word_" + page_index, List.of(Component.m_237115_((String)"text.reactive.devoid").getString().split("\\s+"))));
                }
            }
            if ((double)e.m_9236_().f_46441_.m_188501_() < 0.3) {
                StringBuilder chaos = new StringBuilder();
                for (int i = 0; i < e.m_9236_().f_46441_.m_216339_(3, 25); ++i) {
                    chaos.append(CHAR_LIST.charAt(e.m_9236_().f_46441_.m_188503_(CHAR_LIST.length())));
                }
                words.add(e.m_9236_().f_46441_.m_188503_(words.size()), chaos.toString());
            } else {
                int index = e.m_9236_().f_46441_.m_188503_(words.size());
                words.add(index, (String)words.get(index));
            }
            String text = (String)words.stream().reduce((s1, s2) -> s1 + " " + s2).get();
            if (text.length() > 250) {
                text = text.substring(0, 250);
            }
            pages.set(page_index, (Tag)StringTag.m_129297_((String)text));
            c.expendPower((Power)Powers.MIND_POWER.get(), WorldSpecificValue.get("water_write_cost", 10, 20));
        }
        c.setDirty();
    }

    private static boolean lowWaterWriting(CrucibleBlockEntity c, ItemEntity e, int threshold) {
        CompoundTag book_tag = e.m_32055_().m_41783_();
        if (book_tag == null) {
            e.m_32055_().m_41700_("pages", (Tag)new ListTag());
            book_tag = e.m_32055_().m_41783_();
        }
        boolean did_anything = false;
        ListTag pages = book_tag.m_128437_("pages", 8);
        for (int page_index = 0; page_index < pages.size() && c.getPowerLevel((Power)Powers.MIND_POWER.get()) <= threshold; ++page_index) {
            ArrayList<String> words = new ArrayList<String>(List.of(pages.get(page_index).m_7916_().split("\\s+")));
            if (words.isEmpty()) continue;
            did_anything = true;
            String victim = (String)words.get(e.m_9236_().f_46441_.m_188503_(words.size()));
            String blank = " ".repeat(victim.length());
            pages.set(page_index, (Tag)StringTag.m_129297_((String)pages.get(page_index).m_7916_().replace(victim, blank)));
            c.addPower((Power)Powers.MIND_POWER.get(), WorldSpecificValue.get("water_write_cost", 10, 20) - 1);
        }
        c.setDirty();
        return did_anything;
    }

    private static void residualSlime(CrucibleBlockEntity c, ItemEntity e) {
        c.expendPower((Power)Powers.VERDANT_POWER.get(), 400);
        c.setDirty();
        if (e.m_32055_().m_41613_() == 1) {
            e.m_6074_();
        } else {
            e.m_32055_().m_41774_(1);
        }
        Slime slime = new Slime(EntityType.f_20526_, Objects.requireNonNull(c.obtainLevel()));
        slime.m_146884_(Vec3.m_82512_((Vec3i)c.m_58899_()).m_82520_(0.0, 0.1, 0.0));
        slime.m_7839_(1, true);
        c.obtainLevel().m_7967_((Entity)slime);
    }

    private static void displaceNearby(CrucibleBlockEntity c) {
        Optional target = BlockPos.m_121930_((BlockPos)c.m_58899_(), (int)((Integer)ConfigMan.COMMON.crucibleRange.get()), (int)((Integer)ConfigMan.COMMON.crucibleRange.get()), blockPos -> {
            BlockState state = Objects.requireNonNull(c.obtainLevel()).m_8055_(blockPos);
            return !blockPos.equals((Object)c.m_58899_()) && !state.m_60795_() && !state.m_60713_((Block)Registration.VOLT_CELL.get());
        });
        if (target.isPresent()) {
            DisplacedBlock.displace(c.obtainLevel().m_8055_((BlockPos)target.get()), (BlockPos)target.get(), c.obtainLevel(), 200);
            for (int i = 0; i < 2; ++i) {
                ParticleScribe.drawParticleZigZag(c.obtainLevel(), (ParticleOptions)ParticleTypes.f_175830_, c.m_58899_(), (BlockPos)target.get(), 5, 8, 0.9f);
            }
        }
    }

    private static void soulEscape(CrucibleBlockEntity c) {
        if (c.obtainLevel() == null) {
            return;
        }
        if (c.obtainLevel().m_5776_()) {
            c.obtainLevel().m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.65, (double)c.m_58899_().m_123343_() + 0.5, 0.0, 0.0, 0.0);
        } else {
            ((ServerLevel)c.obtainLevel()).m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.65, (double)c.m_58899_().m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void curseEscape(CrucibleBlockEntity c) {
        if (c.obtainLevel() == null) {
            return;
        }
        AABB aoe = new AABB(c.m_58899_());
        aoe = aoe.m_82400_(5.0);
        if (!c.obtainLevel().m_5776_()) {
            if (c.getPowerLevel((Power)Powers.CURSE_POWER.get()) > 1400) {
                Object m = (double)c.obtainLevel().m_213780_().m_188501_() < 0.35 ? new Skeleton(EntityType.f_20524_, c.obtainLevel()) : new Zombie(EntityType.f_20501_, c.obtainLevel());
                m.m_20225_(true);
                m.m_146884_(aoe.m_82399_().m_82520_((double)WorldSpecificValue.get("monster_summon_x", -5, 5), 1.0, (double)WorldSpecificValue.get("monster_summon_z", -5, 5)));
                c.obtainLevel().m_7967_((Entity)m);
            }
            List nearby_ents = c.obtainLevel().m_45976_(LivingEntity.class, aoe);
            for (LivingEntity e : nearby_ents) {
                if (e.m_6336_().equals(MobType.f_21641_)) continue;
                e.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 300, 0));
                e.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 0));
                e.m_6469_(e.m_9236_().m_269111_().m_269425_(), 10.0f);
                if (!(e instanceof Player)) continue;
                CriteriaTriggers.BE_CURSED_TRIGGER.trigger((ServerPlayer)e);
            }
            c.obtainLevel().m_5594_(null, c.m_58899_(), (SoundEvent)SoundEvents.f_11689_.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void blazeEscape(CrucibleBlockEntity c) {
        if (c.obtainLevel() == null) {
            return;
        }
        AABB blast_zone = new AABB(c.m_58899_());
        blast_zone.m_82377_(1.5, 3.0, 1.5);
        if (!c.obtainLevel().m_5776_()) {
            List nearby_ents = c.obtainLevel().m_45976_(LivingEntity.class, blast_zone);
            for (LivingEntity e : nearby_ents) {
                e.m_6469_(e.m_9236_().m_269111_().m_269387_(), 12.0f);
                e.m_20254_(3);
            }
            c.obtainLevel().m_5594_(null, c.m_58899_(), SoundEvents.f_11705_, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 10; ++i) {
                if (c.getPowerLevel((Power)Powers.SOUL_POWER.get()) > 20) {
                    ParticleScribe.drawParticleCrucibleTop(c.obtainLevel(), (ParticleOptions)ParticleTypes.f_123745_, c.m_58899_(), 1.0f, 0.0, 1.0, 0.0);
                    continue;
                }
                ParticleScribe.drawParticleCrucibleTop(c.obtainLevel(), (ParticleOptions)ParticleTypes.f_123744_, c.m_58899_(), 1.0f, 0.0, 1.0, 0.0);
            }
        }
    }

    private static void verdantEscape(CrucibleBlockEntity c) {
        if (c.obtainLevel() == null || c.obtainLevel().f_46443_ || WorldSpecificValue.getBool("no_moss", 0.5f)) {
            return;
        }
        ((MossBlock)Blocks.f_152544_).m_214148_((ServerLevel)c.obtainLevel(), c.obtainLevel().f_46441_, c.m_58899_().m_7495_(), c.m_58900_());
    }

    private static void lightEscape(CrucibleBlockEntity c) {
        if (c.obtainLevel() == null || c.obtainLevel().f_46443_ || !c.obtainLevel().m_8055_(c.m_58899_().m_7494_()).m_60795_()) {
            return;
        }
        c.obtainLevel().m_7731_(c.m_58899_().m_7494_(), ((Block)Registration.GLOWING_AIR.get()).m_49966_(), 2);
    }

    public static void solidifyPortal(Level l, BlockPos p, Direction.Axis axis) {
        HyperPortalShape portal = new HyperPortalShape((LevelAccessor)l, p, axis);
        if (portal.isComplete()) {
            portal.createSolidPortalBlocks();
            if (!l.f_46443_) {
                FlagCriterion.triggerForNearbyPlayers((ServerLevel)l, CriteriaTriggers.PORTAL_FREEZE_TRIGGER, p, 9);
            }
        }
    }

    private static void preventReactions(CrucibleBlockEntity crucible) {
        crucible.reactions_paused = true;
    }

    private static void expelReaction(CrucibleBlockEntity crucible, ItemEntity thread) {
        Level level;
        if (crucible.obtainLevel() == null) {
            return;
        }
        boolean is_reactive = false;
        for (ReactionStatusEntry entry : crucible.getReactionStatus()) {
            if (!entry.status().equals((Object)Reaction.Status.REACTING)) continue;
            is_reactive = true;
            break;
        }
        if (!is_reactive) {
            return;
        }
        ReactorEntity entity = new ReactorEntity(Registration.REACTOR.get(), crucible.obtainLevel());
        entity.m_146884_(crucible.getPos().m_82520_(0.0, 1.0, 0.0));
        entity.setPowers(crucible.getPowerMap());
        entity.setLifespan(600);
        crucible.expendPower();
        crucible.obtainLevel().m_7731_(crucible.m_58899_(), (BlockState)crucible.m_58900_().m_61124_((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(false)), 2);
        crucible.obtainLevel().m_7967_((Entity)entity);
        crucible.obtainLevel().m_247517_(null, crucible.m_58899_(), SoundEvents.f_11778_, SoundSource.BLOCKS);
        crucible.obtainLevel().m_245803_((Entity)null, crucible.m_58899_(), SoundEvents.f_11705_, SoundSource.BLOCKS, 1.0f, 0.7f);
        thread.m_32055_().m_41774_(1);
        if (thread.m_32055_().m_41613_() == 0) {
            thread.m_6074_();
        }
        if ((level = crucible.obtainLevel()) instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            FlagCriterion.triggerForNearbyPlayers(slevel, CriteriaTriggers.GOLD_THREAD_REACTION, crucible.m_58899_(), 9);
        }
    }

    private static void saltMaterialCraft(CrucibleBlockEntity crucible, ItemEntity salt_item_entity) {
        if (crucible.obtainLevel() == null) {
            return;
        }
        if (crucible.getTotalPowerLevel() < 800 && crucible.getPowerLevel((Power)Powers.ACID_POWER.get()) <= 10) {
            return;
        }
        ItemStack material_stack = ((MaterialItem)((Object)Registration.MATERIAL_ITEM.get())).m_7968_();
        ResourceLocation material_id = MaterialMan.createOrFetchByFormula(crucible.obtainLevel(), new Formula(crucible.getPowerMap(), salt_item_entity.m_32055_().m_41720_()));
        MaterialItem.setMaterialId(material_stack, material_id);
        int max_amount_used = 1;
        int yield_multiplier = 1;
        YieldEntry yield_entry = MaterialFormulaMaps.BASE_YIELDS.get(salt_item_entity.m_32055_().m_41720_().m_204114_().m_205785_().m_135782_());
        if (yield_entry != null) {
            max_amount_used = yield_entry.max_input_items();
            yield_multiplier = yield_entry.yield_per_input();
        }
        int amount_used = Math.min(salt_item_entity.m_32055_().m_41613_(), max_amount_used);
        material_stack.m_41764_(amount_used * yield_multiplier);
        salt_item_entity.m_32055_().m_41774_(amount_used);
        if (salt_item_entity.m_32055_().m_41613_() <= 0) {
            salt_item_entity.m_6074_();
        }
        Vec3 in_crucible = crucible.m_58899_().m_252807_();
        ItemEntity drop = new ItemEntity(crucible.obtainLevel(), in_crucible.f_82479_, in_crucible.f_82480_, in_crucible.f_82481_, material_stack);
        crucible.obtainLevel().m_7967_((Entity)drop);
        crucible.expendPower();
        crucible.setDirty();
    }
}

