/*
 * Decompiled with CFR 0.152.
 */
package dev.hyperlynx.reactive.be;

import dev.hyperlynx.reactive.Registration;
import dev.hyperlynx.reactive.items.MaterialItem;
import dev.hyperlynx.reactive.menu.DeskMenu;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class DeskBlockEntity
extends BaseContainerBlockEntity
implements IItemHandlerModifiable {
    @NotNull
    private ItemStack stack = ItemStack.f_41583_;

    public DeskBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)Registration.DESK_BE.get(), pos, blockState);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"block.reactive.desk");
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory inventory) {
        return new DeskMenu(containerId, inventory);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("stack")) {
            this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("stack"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.stack.m_41619_()) {
            tag.m_128365_("stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        }
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int slot) {
        if (slot > 0) {
            return ItemStack.f_41583_;
        }
        return this.stack;
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.extractItem(slot, amount, false);
    }

    public ItemStack m_8016_(int slot) {
        if (slot > 0) {
            return ItemStack.f_41583_;
        }
        return this.stack.m_41777_();
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.setStackInSlot(slot, stack);
    }

    public boolean m_6542_(Player pPlayer) {
        return true;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot == 0) {
            return this.stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack insertItem(int slot, ItemStack stack_to_insert, boolean simulate) {
        if (!this.isItemValid(slot, stack_to_insert)) {
            return stack_to_insert;
        }
        if (this.stack.m_41619_()) {
            this.stack = stack_to_insert.m_41777_();
            return ItemStack.f_41583_;
        }
        if (!Objects.equals(MaterialItem.getMaterialId(stack_to_insert), MaterialItem.getMaterialId(this.stack))) {
            return stack_to_insert;
        }
        int number_to_move = Math.min(this.stack.m_41741_() - this.stack.m_41613_(), stack_to_insert.m_41613_());
        ItemStack after_items_depleted = stack_to_insert.m_255036_(stack_to_insert.m_41613_() - number_to_move);
        if (!simulate) {
            this.stack.m_41764_(this.stack.m_41613_() + number_to_move);
        }
        return after_items_depleted;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0) {
            return ItemStack.f_41583_;
        }
        if (amount > this.stack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        ItemStack extracted = this.stack.m_255036_(amount);
        if (!simulate) {
            this.stack.m_41774_(amount);
            if (this.stack.m_41613_() == 0) {
                this.stack = ItemStack.f_41583_;
            }
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot == 0 && stack.m_150930_((Item)Registration.MATERIAL_ITEM.get());
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (slot != 0) {
            return;
        }
        this.stack = stack.m_41777_();
    }

    public void m_6211_() {
        this.stack = ItemStack.f_41583_;
    }
}

